/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.adapter.xs;

import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.json.JsonParsingException;
import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.GrantType;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.client.XsuaaOAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import com.sap.xsa.security.container.XSTokenRequest;
import com.sap.xsa.security.container.XSUserInfo;
import com.sap.xsa.security.container.XSUserInfoException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSUserInfoAdapter
implements XSUserInfo {
    static final String EXTERNAL_CONTEXT = "ext_ctx";
    static final String CLAIM_ADDITIONAL_AZ_ATTR = "az_attr";
    static final String XS_SYSTEM_ATTRIBUTES = "xs.system.attributes";
    static final String HDB_NAMEDUSER_SAML = "hdb.nameduser.saml";
    static final String SERVICEINSTANCEID = "serviceinstanceid";
    static final String SYSTEM = "SYSTEM";
    static final String HDB = "HDB";
    private static final Logger LOGGER = LoggerFactory.getLogger(XSUserInfoAdapter.class);
    private final AccessToken accessToken;
    private final OAuth2ServiceConfiguration configuration;
    private OAuth2TokenService oAuth2TokenService;

    public XSUserInfoAdapter(Object accessToken) {
        this(accessToken, Environments.getCurrent().getXsuaaConfiguration());
    }

    public XSUserInfoAdapter(AccessToken accessToken) {
        this(accessToken, Environments.getCurrent().getXsuaaConfiguration());
    }

    XSUserInfoAdapter(Object accessToken, OAuth2ServiceConfiguration configuration) {
        if (!(accessToken instanceof AccessToken)) {
            String type = Objects.isNull(accessToken) ? null : accessToken.getClass().getName();
            throw new XSUserInfoException("token is of instance " + type + " but needs to be an instance of AccessToken.");
        }
        this.accessToken = (AccessToken)accessToken;
        this.configuration = configuration;
    }

    public String getLogonName() {
        this.checkNotGrantTypeClientCredentials("getLogonName");
        return this.getClaimValue("user_name");
    }

    public String getGivenName() {
        this.checkNotGrantTypeClientCredentials("getGivenName");
        String externalAttributeName = this.getExternalAttribute("given_name");
        if (externalAttributeName == null) {
            return this.getClaimValue("given_name");
        }
        return externalAttributeName;
    }

    public String getFamilyName() {
        this.checkNotGrantTypeClientCredentials("getFamilyName");
        String externalAttributeName = this.getExternalAttribute("family_name");
        if (externalAttributeName == null) {
            return this.getClaimValue("family_name");
        }
        return externalAttributeName;
    }

    public String getOrigin() {
        this.checkNotGrantTypeClientCredentials("getOrigin");
        return this.getClaimValue("origin");
    }

    public String getIdentityZone() {
        return this.getClaimValue("zid");
    }

    public String getSubaccountId() {
        return Optional.ofNullable(this.getExternalAttribute("subaccountid")).orElse(this.getClaimValue("zid"));
    }

    public String getZoneId() {
        return this.accessToken.hasClaim("zone_uuid") ? this.accessToken.getClaimAsString("zone_uuid") : this.getClaimValue("zid");
    }

    public String getSubdomain() {
        return Optional.ofNullable(this.getExternalAttribute("zdn")).orElse(null);
    }

    public String getClientId() {
        return this.accessToken.getClientId();
    }

    public String getJsonValue(String attribute) {
        return this.getClaimValue(attribute);
    }

    public String getEmail() {
        this.checkNotGrantTypeClientCredentials("getEmail");
        return this.getClaimValue("email");
    }

    public String getDBToken() {
        return this.getHdbToken();
    }

    public String getHdbToken() {
        return this.getToken(SYSTEM, HDB);
    }

    public String getAppToken() {
        return this.accessToken.getTokenValue();
    }

    public String getToken(String namespace, String name) {
        if (!this.getGrantType().equals(GrantType.CLIENT_CREDENTIALS.toString()) && this.hasAttributes() && this.isInForeignMode()) {
            throw new XSUserInfoException("The SecurityContext has been initialized with an access token of a foreign OAuth Client Id and/or Identity Zone. Furthermore, the access token contains attributes. Due to the fact that we want to restrict attribute access to the application that provides the attributes, the getToken() function does not return a token.");
        }
        if (!namespace.equals(SYSTEM)) {
            throw new XSUserInfoException("Invalid namespace " + namespace);
        }
        if (name.equals(HDB)) {
            String token = this.accessToken.hasClaim(EXTERNAL_CONTEXT) ? this.accessToken.getAttributeFromClaimAsString(EXTERNAL_CONTEXT, HDB_NAMEDUSER_SAML) : this.accessToken.getClaimAsString(HDB_NAMEDUSER_SAML);
            if (token == null) {
                token = this.accessToken.getTokenValue();
            }
            return token;
        }
        if (name.equals("JobScheduler")) {
            return this.accessToken.getTokenValue();
        }
        throw new XSUserInfoException("Invalid name " + name + " for namespace " + namespace);
    }

    public String[] getAttribute(String attributeName) {
        this.checkNotGrantTypeClientCredentials("getAttribute");
        return this.getMultiValueAttributeFromExtObject("xs.user.attributes", attributeName);
    }

    public boolean hasAttributes() {
        this.checkNotGrantTypeClientCredentials("hasAttributes");
        if (this.accessToken.hasClaim(EXTERNAL_CONTEXT)) {
            JsonObject extContext = this.getClaimAsJsonObject(EXTERNAL_CONTEXT);
            return extContext != null && extContext.contains("xs.user.attributes") && !extContext.getJsonObject(EXTERNAL_CONTEXT).isEmpty();
        }
        JsonObject xsUserAttributes = this.getClaimAsJsonObject("xs.user.attributes");
        return xsUserAttributes != null && !xsUserAttributes.isEmpty();
    }

    public String[] getSystemAttribute(String attributeName) {
        return this.getMultiValueAttributeFromExtObject(XS_SYSTEM_ATTRIBUTES, attributeName);
    }

    public boolean checkScope(String scope) {
        return this.accessToken.hasScope(scope);
    }

    public boolean checkLocalScope(String scope) {
        try {
            return this.accessToken.hasLocalScope(scope);
        }
        catch (IllegalArgumentException e) {
            throw new XSUserInfoException(e.getMessage());
        }
    }

    public String getAdditionalAuthAttribute(String attributeName) {
        return Optional.ofNullable(this.accessToken.getAttributeFromClaimAsString(CLAIM_ADDITIONAL_AZ_ATTR, attributeName)).orElseThrow(this.createXSUserInfoException(attributeName));
    }

    public String getCloneServiceInstanceId() {
        return Optional.ofNullable(this.getExternalAttribute(SERVICEINSTANCEID)).orElseThrow(this.createXSUserInfoException(SERVICEINSTANCEID));
    }

    public String getGrantType() {
        return Optional.ofNullable(this.accessToken.getGrantType()).map(GrantType::toString).orElseThrow(this.createXSUserInfoException("grant_type"));
    }

    public boolean isInForeignMode() {
        String tokenIdentityZone;
        String tokenClientId;
        if (this.configuration == null) {
            LOGGER.info("No configuration provided -> falling back to foreignMode = true!");
            return true;
        }
        try {
            tokenClientId = this.getClientId();
            tokenIdentityZone = this.getIdentityZone();
        }
        catch (XSUserInfoException e) {
            LOGGER.warn("Tried to access missing attribute when checking for foreign mode", (Throwable)e);
            return true;
        }
        boolean clientIdsMatch = tokenClientId.equals(this.configuration.getClientId());
        boolean identityZonesMatch = tokenIdentityZone.equals(this.configuration.getProperty("identityzone"));
        boolean isApplicationPlan = tokenClientId.contains("!t");
        boolean isBrokerPlan = tokenClientId.contains("!b");
        if (clientIdsMatch && (identityZonesMatch || isApplicationPlan || isBrokerPlan)) {
            LOGGER.info("Token not in foreign mode because because client ids match and identityZonesMatch={}, isApplicationPlan={} ", (Object)identityZonesMatch, (Object)isApplicationPlan);
            return false;
        }
        String bindingTrustedClientIdSuffix = this.configuration.getProperty("trustedclientidsuffix");
        if (bindingTrustedClientIdSuffix != null && tokenClientId.endsWith(bindingTrustedClientIdSuffix)) {
            LOGGER.info("Token not in foreign mode because token client id matches binding trusted client suffix");
            return false;
        }
        LOGGER.info("Token in foreign mode: clientIdsMatch={}, identityZonesMatch={}, isApplicationPlan={}, bindingTrustedClientIdSuffix={}", new Object[]{clientIdsMatch, identityZonesMatch, isApplicationPlan, bindingTrustedClientIdSuffix});
        return true;
    }

    public String requestTokenForClient(String clientId, String clientSecret, String baseUaaUrl) {
        return this.performTokenFlow(baseUaaUrl, 1, clientId, clientSecret, new HashMap<String, String>());
    }

    public String requestTokenForUser(String clientId, String clientSecret, String baseUaaUrl) {
        return this.performTokenFlow(baseUaaUrl, 0, clientId, clientSecret, new HashMap<String, String>());
    }

    public String requestToken(XSTokenRequest tokenRequest) {
        Assertions.assertNotNull((Object)tokenRequest, (String)"TokenRequest argument is required");
        if (!tokenRequest.isValid()) {
            throw new XSUserInfoException("Invalid grant type or missing parameters for requested grant type.");
        }
        String tokenEndpoint = tokenRequest.getTokenEndpoint().toString();
        String baseUaaUrl = tokenEndpoint.replace(tokenRequest.getTokenEndpoint().getPath(), "");
        Map additionalAuthAttributes = tokenRequest.getAdditionalAuthorizationAttributes();
        return this.performTokenFlow(baseUaaUrl, tokenRequest.getType(), tokenRequest.getClientId(), tokenRequest.getClientSecret(), additionalAuthAttributes);
    }

    private OAuth2TokenService getOrCreateOAuth2TokenService() {
        if (this.oAuth2TokenService == null) {
            this.oAuth2TokenService = this.tryToCreateDefaultOAuth2TokenService();
            if (this.oAuth2TokenService == null) {
                this.oAuth2TokenService = this.tryToCreateXsuaaOAuth2TokenService();
            }
        }
        if (this.oAuth2TokenService == null) {
            throw new UnsupportedOperationException("Failed to create OAuth2TokenService. Make sure your project has a dependency to either spring-web or apache HTTP client.");
        }
        return this.oAuth2TokenService;
    }

    private OAuth2TokenService tryToCreateDefaultOAuth2TokenService() {
        LOGGER.debug("Trying to create DefaultOAuth2TokenService.");
        try {
            return new DefaultOAuth2TokenService();
        }
        catch (Exception | LinkageError e) {
            LOGGER.debug("Failed to create DefaultOAuth2TokenService.", e);
            return null;
        }
    }

    private OAuth2TokenService tryToCreateXsuaaOAuth2TokenService() {
        LOGGER.debug("Trying to create XsuaaOAuth2TokenService.");
        try {
            return new XsuaaOAuth2TokenService();
        }
        catch (Exception | LinkageError e) {
            LOGGER.debug("Failed to create XsuaaOAuth2TokenService.", e);
            return null;
        }
    }

    void setOAuth2TokenService(OAuth2TokenService oAuth2TokenService) {
        this.oAuth2TokenService = oAuth2TokenService;
    }

    private String[] getMultiValueAttributeFromExtObject(String claimName, String attributeName) {
        List claims = this.accessToken.getAttributeFromClaimAsStringList(claimName, attributeName);
        if (claims.isEmpty()) {
            throw new XSUserInfoException("Invalid user attribute " + attributeName);
        }
        return claims.toArray(new String[0]);
    }

    private void checkNotGrantTypeClientCredentials(String methodName) {
        if (GrantType.CLIENT_CREDENTIALS == this.accessToken.getGrantType()) {
            String message = String.format("Method '%s' is not supported for grant type '%s'", methodName, GrantType.CLIENT_CREDENTIALS);
            throw new XSUserInfoException(message + GrantType.CLIENT_CREDENTIALS);
        }
    }

    private Supplier<XSUserInfoException> createXSUserInfoException(String attribute) {
        return () -> new XSUserInfoException("Invalid user attribute " + attribute);
    }

    private String getClaimValue(String claimname) {
        String value = this.accessToken.getClaimAsString(claimname);
        if (value == null) {
            throw new XSUserInfoException("Invalid user attribute " + claimname);
        }
        return value;
    }

    @Nullable
    private JsonObject getClaimAsJsonObject(String claimName) {
        try {
            return this.accessToken.getClaimAsJsonObject(claimName);
        }
        catch (JsonParsingException e) {
            throw this.createXSUserInfoException(claimName).get();
        }
    }

    String getExternalAttribute(String attributeName) {
        return this.accessToken.getAttributeFromClaimAsString("ext_attr", attributeName);
    }

    XsuaaTokenFlows getXsuaaTokenFlows(String baseUaaUrl, ClientIdentity clientIdentity) {
        return new XsuaaTokenFlows(this.getOrCreateOAuth2TokenService(), (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(baseUaaUrl, null), clientIdentity);
    }

    private String performTokenFlow(String baseUaaUrl, int tokenRequestType, String clientId, String clientSecret, Map<String, String> additionalAuthAttributes) {
        try {
            ClientCredentials clientIdentity = new ClientCredentials(clientId, clientSecret);
            XsuaaTokenFlows xsuaaTokenFlows = this.getXsuaaTokenFlows(baseUaaUrl, (ClientIdentity)clientIdentity);
            return this.performRequest(xsuaaTokenFlows, tokenRequestType, additionalAuthAttributes);
        }
        catch (RuntimeException e) {
            throw new XSUserInfoException(e.getMessage());
        }
    }

    private String performRequest(XsuaaTokenFlows xsuaaTokenFlows, int tokenRequestType, Map<String, String> additionalAuthAttributes) {
        switch (tokenRequestType) {
            case 0: {
                return this.performUserTokenFlow(xsuaaTokenFlows, additionalAuthAttributes);
            }
            case 1: {
                return this.performClientCredentialsFlow(xsuaaTokenFlows, additionalAuthAttributes);
            }
        }
        throw new XSUserInfoException("Found unsupported XSTokenRequest type. The only supported types are XSTokenRequest.TYPE_USER_TOKEN and XSTokenRequest.TYPE_CLIENT_CREDENTIALS_TOKEN.");
    }

    private String performUserTokenFlow(XsuaaTokenFlows xsuaaTokenFlows, Map<String, String> additionalAuthAttributes) {
        String userToken;
        try {
            userToken = xsuaaTokenFlows.userTokenFlow().subdomain(this.getSubdomain()).token(this.getAppToken()).attributes(additionalAuthAttributes).execute().getAccessToken();
        }
        catch (TokenFlowException e) {
            LOGGER.error("Error performing User Token Flow", (Throwable)e);
            throw new XSUserInfoException("Error performing User Token Flow.", (Throwable)e);
        }
        return userToken;
    }

    private String performClientCredentialsFlow(XsuaaTokenFlows xsuaaTokenFlows, Map<String, String> additionalAuthAttributes) {
        String ccfToken;
        try {
            ccfToken = xsuaaTokenFlows.clientCredentialsTokenFlow().subdomain(this.getSubdomain()).attributes(additionalAuthAttributes).execute().getAccessToken();
        }
        catch (TokenFlowException e) {
            LOGGER.error("Error performing Client Credentials Flow", (Throwable)e);
            throw new XSUserInfoException("Error performing Client Credentials Flow.", (Throwable)e);
        }
        return ccfToken;
    }
}

