/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.token.AbstractToken;
import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.GrantType;
import com.sap.cloud.security.token.InvalidTokenException;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.security.Principal;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsuaaToken
extends AbstractToken
implements AccessToken {
    private static final long serialVersionUID = 3304172041930251807L;
    static final String UNIQUE_USER_NAME_FORMAT = "user/%s/%s";
    static final String UNIQUE_CLIENT_NAME_FORMAT = "client/%s";
    private static final Logger LOGGER = LoggerFactory.getLogger(XsuaaToken.class);
    private ScopeConverter scopeConverter;

    public XsuaaToken(@Nonnull DecodedJwt decodedJwt) {
        super(decodedJwt);
    }

    public XsuaaToken(@Nonnull String accessToken) {
        super(accessToken);
    }

    static String getUniquePrincipalName(String origin, String userName) {
        if (XsuaaToken.isNullOrEmpty(origin)) {
            LOGGER.warn("origin claim not set in JWT. Cannot create unique user name. Returning null.");
            return null;
        }
        if (XsuaaToken.isNullOrEmpty(userName)) {
            LOGGER.warn("user_name claim not set in JWT. Cannot create unique user name. Returning null.");
            return null;
        }
        if (origin.contains("/")) {
            LOGGER.warn("Illegal '/' character detected in origin claim of JWT. Cannot create unique user name. Returning null.");
            return null;
        }
        return String.format(UNIQUE_USER_NAME_FORMAT, origin, userName);
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public XsuaaToken withScopeConverter(@Nullable ScopeConverter converter) {
        this.scopeConverter = converter;
        return this;
    }

    public Set<String> getScopes() {
        return new LinkedHashSet<String>(this.getClaimAsStringList("scope"));
    }

    public Principal getPrincipal() {
        String principalName;
        switch (this.getGrantType()) {
            case CLIENT_CREDENTIALS: 
            case CLIENT_X509: {
                principalName = String.format(UNIQUE_CLIENT_NAME_FORMAT, this.getClientId());
                break;
            }
            default: {
                principalName = XsuaaToken.getUniquePrincipalName(this.getClaimAsString("origin"), this.getClaimAsString("user_name"));
            }
        }
        return this.createPrincipalByName(principalName);
    }

    public Service getService() {
        return Service.XSUAA;
    }

    public boolean hasScope(String scope) {
        return this.getScopes().contains(scope);
    }

    public boolean hasLocalScope(@Nonnull String scope) {
        Assertions.assertNotNull((Object)this.scopeConverter, (String)"hasLocalScope() method requires a scopeConverter, which must not be null");
        return this.scopeConverter.convert(this.getScopes()).contains(scope);
    }

    public GrantType getGrantType() {
        return GrantType.from((String)this.getClaimAsString("grant_type"));
    }

    @Nullable
    public String getSubdomain() {
        return this.getAttributeFromClaimAsString("ext_attr", "zdn");
    }

    public String getSubaccountId() {
        return Optional.ofNullable(this.getAttributeFromClaimAsString("ext_attr", "subaccountid")).orElse(this.getClaimAsString("zid"));
    }

    public String getZoneId() {
        return this.getAppTid();
    }

    public String getAppTid() {
        return this.getClaimAsString("zid");
    }

    public String getClientId() {
        try {
            return super.getClientId();
        }
        catch (InvalidTokenException ex) {
            if (this.hasClaim("cid") && !this.getClaimAsString("cid").trim().isEmpty()) {
                LOGGER.warn("Usage of 'cid' claim is deprecated and should be replaced by 'azp' or 'aud' claims");
                return this.getClaimAsString("cid");
            }
            LOGGER.error("Couldn't get client id. Invalid authorized party or audience claims.");
            throw new InvalidTokenException("Couldn't get client id. Invalid authorized party or audience claims.");
        }
    }
}

