/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.token.validation.validators.JsonWebKey;
import com.sap.cloud.security.token.validation.validators.JwtSignatureAlgorithm;
import com.sap.cloud.security.xsuaa.Assertions;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.Nullable;

class JsonWebKeyImpl
implements JsonWebKey {
    private final JwtSignatureAlgorithm keyAlgorithm;
    private final String keyId;
    private final String pemEncodedPublicKey;
    private final String modulus;
    private final String publicExponent;
    private PublicKey publicKey;

    JsonWebKeyImpl(JwtSignatureAlgorithm keyAlgorithm, @Nullable String keyId, String modulus, String publicExponent, @Nullable String pemEncodedPublicKey) {
        Assertions.assertNotNull((Object)((Object)keyAlgorithm), (String)"keyAlgorithm must be not null");
        this.keyId = keyId != null ? keyId : "default-kid";
        this.pemEncodedPublicKey = pemEncodedPublicKey;
        this.publicExponent = publicExponent;
        this.modulus = modulus;
        this.keyAlgorithm = keyAlgorithm;
    }

    @Override
    public JwtSignatureAlgorithm getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    @Override
    @Nullable
    public String getId() {
        return this.keyId;
    }

    @Override
    public PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        if (this.pemEncodedPublicKey != null) {
            this.publicKey = JsonWebKeyImpl.createPublicKeyFromPemEncodedPublicKey(this.keyAlgorithm, this.pemEncodedPublicKey);
        } else if (this.keyAlgorithm.type().equalsIgnoreCase("RSA")) {
            this.publicKey = JsonWebKeyImpl.createRSAPublicKey(this.publicExponent, this.modulus);
        } else {
            throw new IllegalStateException("JWT token with web key type " + (Object)((Object)this.keyAlgorithm) + " can not be verified.");
        }
        return this.publicKey;
    }

    static PublicKey createRSAPublicKey(String publicExponent, String modulus) throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger n = new BigInteger(1, Base64.getUrlDecoder().decode(modulus));
        BigInteger e = new BigInteger(1, Base64.getUrlDecoder().decode(publicExponent));
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(n, e);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    public static PublicKey createPublicKeyFromPemEncodedPublicKey(JwtSignatureAlgorithm algorithm, String pemEncodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] decodedBytes = Base64.getMimeDecoder().decode(JsonWebKeyImpl.convertPEMKey(pemEncodedKey));
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(decodedBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm.type());
        return keyFactory.generatePublic(keySpecX509);
    }

    public static String convertPEMKey(String pemEncodedKey) {
        String key = pemEncodedKey;
        key = key.replace("-----BEGIN PUBLIC KEY-----", "");
        key = key.replace("-----END PUBLIC KEY-----", "");
        return key;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyAlgorithm, this.keyId != null ? this.keyId : "default-kid"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonWebKeyImpl that = (JsonWebKeyImpl)o;
        if (this.getKeyAlgorithm() != that.getKeyAlgorithm()) {
            return false;
        }
        return this.keyId.equals(that.keyId);
    }

    public String toString() {
        return this.getId() + "(" + (Object)((Object)this.getKeyAlgorithm()) + ")";
    }
}

