/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.servlet.AbstractTokenAuthenticator;
import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.token.SapIdToken;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.x509.Certificate;
import com.sap.cloud.security.x509.X509Certificate;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class IasTokenAuthenticator
extends AbstractTokenAuthenticator {
    @Override
    public Token extractFromHeader(String authorizationHeader) {
        return new SapIdToken(authorizationHeader);
    }

    @Override
    public TokenAuthenticationResult validateRequest(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        SecurityContext.setClientCertificate((Certificate)X509Certificate.newCertificate(this.getClientCertificate(httpRequest)));
        return super.validateRequest(request, response);
    }

    @Override
    protected OAuth2ServiceConfiguration getServiceConfiguration() {
        OAuth2ServiceConfiguration config;
        OAuth2ServiceConfiguration oAuth2ServiceConfiguration = config = this.serviceConfiguration != null ? this.serviceConfiguration : Environments.getCurrent().getIasConfiguration();
        if (config == null) {
            throw new IllegalStateException("There must be a service configuration.");
        }
        return config;
    }

    @Override
    @Nullable
    protected OAuth2ServiceConfiguration getOtherServiceConfiguration() {
        return null;
    }
}

