/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.sap.cloud.security.config.CacheConfiguration;
import com.sap.cloud.security.token.validation.validators.JsonWebKey;
import com.sap.cloud.security.token.validation.validators.JsonWebKeySet;
import com.sap.cloud.security.token.validation.validators.JsonWebKeySetFactory;
import com.sap.cloud.security.token.validation.validators.JwtSignatureAlgorithm;
import com.sap.cloud.security.token.validation.validators.TokenKeyCacheConfiguration;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.tokenflows.Cacheable;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth2TokenKeyServiceWithCache
implements Cacheable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2TokenKeyServiceWithCache.class);
    private OAuth2TokenKeyService tokenKeyService;
    private Cache<String, JsonWebKeySet> cache;
    private CacheConfiguration cacheConfiguration = TokenKeyCacheConfiguration.defaultConfiguration();
    private Ticker cacheTicker;

    private OAuth2TokenKeyServiceWithCache() {
    }

    public static OAuth2TokenKeyServiceWithCache getInstance() {
        OAuth2TokenKeyServiceWithCache instance = new OAuth2TokenKeyServiceWithCache();
        instance.cacheTicker = Ticker.systemTicker();
        return instance;
    }

    static OAuth2TokenKeyServiceWithCache getInstance(Ticker cacheTicker) {
        OAuth2TokenKeyServiceWithCache instance = new OAuth2TokenKeyServiceWithCache();
        instance.cacheTicker = cacheTicker;
        return instance;
    }

    @Deprecated
    public OAuth2TokenKeyServiceWithCache withCacheTime(int timeInSeconds) {
        this.withCacheConfiguration(TokenKeyCacheConfiguration.getInstance(Duration.ofSeconds(timeInSeconds), this.cacheConfiguration.getCacheSize(), false));
        return this;
    }

    @Deprecated
    public OAuth2TokenKeyServiceWithCache withCacheSize(int size) {
        this.withCacheConfiguration(TokenKeyCacheConfiguration.getInstance(this.cacheConfiguration.getCacheDuration(), size, false));
        return this;
    }

    public OAuth2TokenKeyServiceWithCache withCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = this.getCheckedConfiguration(cacheConfiguration);
        LOGGER.debug("Configured token key cache with cacheDuration={} seconds, cacheSize={} and statisticsRecording={}", new Object[]{this.getCacheConfiguration().getCacheDuration().getSeconds(), this.getCacheConfiguration().getCacheSize(), this.getCacheConfiguration().isCacheStatisticsEnabled()});
        return this;
    }

    public OAuth2TokenKeyServiceWithCache withTokenKeyService(OAuth2TokenKeyService tokenKeyService) {
        this.tokenKeyService = tokenKeyService;
        return this;
    }

    @Nullable
    @Deprecated
    public PublicKey getPublicKey(JwtSignatureAlgorithm keyAlgorithm, String keyId, URI keyUri) {
        throw new UnsupportedOperationException("use getPublicKey(keyAlgorithm, keyId, keyUri, params) instead");
    }

    @Nullable
    public PublicKey getPublicKey(JwtSignatureAlgorithm keyAlgorithm, String keyId, URI keyUri, String appTid) throws OAuth2ServiceException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.getPublicKey(keyAlgorithm, keyId, keyUri, Collections.singletonMap("x-app_tid", appTid));
    }

    public PublicKey getPublicKey(JwtSignatureAlgorithm keyAlgorithm, String keyId, URI keyUri, Map<String, String> params) throws OAuth2ServiceException, InvalidKeySpecException, NoSuchAlgorithmException {
        Assertions.assertNotNull((Object)((Object)keyAlgorithm), (String)"keyAlgorithm must not be null.");
        Assertions.assertHasText((String)keyId, (String)"keyId must not be null.");
        Assertions.assertNotNull((Object)keyUri, (String)"keyUrl must not be null.");
        CacheKey cacheKey = new CacheKey(keyUri, params);
        JsonWebKeySet jwks = (JsonWebKeySet)this.getCache().getIfPresent((Object)cacheKey.toString());
        if (jwks == null) {
            jwks = this.retrieveTokenKeysAndUpdateCache(cacheKey);
        }
        if (jwks.getAll().isEmpty()) {
            LOGGER.error("Retrieved no token keys from {} for the given header parameters.", (Object)keyUri);
            return null;
        }
        for (JsonWebKey jwk : jwks.getAll()) {
            if (!keyId.equals(jwk.getId()) || !jwk.getKeyAlgorithm().equals((Object)keyAlgorithm)) continue;
            return jwk.getPublicKey();
        }
        LOGGER.warn("No matching key found. Cached keys: {}", (Object)jwks);
        throw new IllegalArgumentException("Key with kid " + keyId + " not found in JWKS.");
    }

    private JsonWebKeySet retrieveTokenKeysAndUpdateCache(CacheKey cacheKey) throws OAuth2ServiceException {
        String jwksJson = this.getTokenKeyService().retrieveTokenKeys(cacheKey.keyUri(), cacheKey.params());
        JsonWebKeySet keySet = JsonWebKeySetFactory.createFromJson(jwksJson);
        this.getCache().put((Object)cacheKey.toString(), (Object)keySet);
        return keySet;
    }

    private TokenKeyCacheConfiguration getCheckedConfiguration(CacheConfiguration cacheConfiguration) {
        Assertions.assertNotNull((Object)cacheConfiguration, (String)"CacheConfiguration must not be null!");
        int size = cacheConfiguration.getCacheSize();
        Duration duration = cacheConfiguration.getCacheDuration();
        if (size < 1000) {
            int currentSize = this.getCacheConfiguration().getCacheSize();
            LOGGER.error("Tried to set cache size to {} but the cache size must be 1000 or more. Cache size will remain at: {}", (Object)size, (Object)currentSize);
            size = currentSize;
        }
        if (duration.getSeconds() < 600L) {
            Duration currentDuration = this.getCacheConfiguration().getCacheDuration();
            LOGGER.error("Tried to set cache duration to {} seconds but the cache duration must be at least 600 seconds. Cache duration will remain at: {} seconds", (Object)duration.getSeconds(), (Object)currentDuration.getSeconds());
            duration = currentDuration;
        }
        if (duration.getSeconds() > 900L) {
            Duration currentDuration = this.getCacheConfiguration().getCacheDuration();
            LOGGER.error("Tried to set cache duration to {} seconds but the cache duration must be maximum 900 seconds. Cache duration will remain at: {} seconds", (Object)duration.getSeconds(), (Object)currentDuration.getSeconds());
            duration = currentDuration;
        }
        return TokenKeyCacheConfiguration.getInstance(duration, size, cacheConfiguration.isCacheStatisticsEnabled());
    }

    private Cache<String, JsonWebKeySet> getCache() {
        if (this.cache == null) {
            Caffeine cacheBuilder = Caffeine.newBuilder().ticker(this.cacheTicker).expireAfterWrite(this.getCacheConfiguration().getCacheDuration()).maximumSize((long)this.getCacheConfiguration().getCacheSize());
            if (this.getCacheConfiguration().isCacheStatisticsEnabled()) {
                cacheBuilder.recordStats();
            }
            this.cache = cacheBuilder.build();
        }
        return this.cache;
    }

    private OAuth2TokenKeyService getTokenKeyService() {
        if (this.tokenKeyService == null) {
            this.tokenKeyService = new DefaultOAuth2TokenKeyService();
        }
        return this.tokenKeyService;
    }

    @Nonnull
    public CacheConfiguration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    public Object getCacheStatistics() {
        return this.getCacheConfiguration().isCacheStatisticsEnabled() ? this.getCache().stats() : null;
    }

    private static class CacheKey {
        private final URI keyUri;
        private final Map<String, String> params;

        public CacheKey(URI keyUri, Map<String, String> params) {
            this.keyUri = keyUri;
            this.params = params;
        }

        public URI keyUri() {
            return this.keyUri;
        }

        public Map<String, String> params() {
            return this.params;
        }

        public String toString() {
            String paramString = this.params.entrySet().stream().filter(e -> e.getValue() != null).map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining("|"));
            return String.format("url:%s|%s", this.keyUri, paramString);
        }
    }
}

