/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.servlet.TokenAuthenticator;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationListener;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.token.validation.validators.JwtValidatorBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTokenAuthenticator
implements TokenAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTokenAuthenticator.class);
    private final List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();
    private Validator<Token> tokenValidator;
    protected CloseableHttpClient httpClient;
    protected OAuth2ServiceConfiguration serviceConfiguration;

    @Override
    public TokenAuthenticationResult validateRequest(ServletRequest request, ServletResponse response) {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String authorizationHeader = httpRequest.getHeader("Authorization");
            if (this.headerIsAvailable(authorizationHeader)) {
                try {
                    Token token = this.extractFromHeader(authorizationHeader);
                    ValidationResult result = this.getOrCreateTokenValidator().validate(token);
                    if (result.isValid()) {
                        SecurityContext.setToken(token);
                        return this.authenticated(token);
                    }
                    return this.unauthenticated(httpResponse, "Error during token validation: " + result.getErrorDescription());
                }
                catch (Exception e) {
                    return this.unauthenticated(httpResponse, "Unexpected error occurred: " + e.getMessage());
                }
            }
            return this.unauthenticated(httpResponse, "Authorization header is missing.");
        }
        return TokenAuthenticationResult.createUnauthenticated("Could not process request " + request);
    }

    public AbstractTokenAuthenticator withHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public AbstractTokenAuthenticator withServiceConfiguration(OAuth2ServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
        return this;
    }

    public AbstractTokenAuthenticator withValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
        return this;
    }

    protected abstract OAuth2ServiceConfiguration getServiceConfiguration();

    protected abstract Token extractFromHeader(String var1);

    private Validator<Token> getOrCreateTokenValidator() {
        if (this.tokenValidator == null) {
            JwtValidatorBuilder jwtValidatorBuilder = JwtValidatorBuilder.getInstance(this.getServiceConfiguration()).withHttpClient(this.httpClient);
            this.validationListeners.forEach(jwtValidatorBuilder::withValidatorListener);
            this.tokenValidator = jwtValidatorBuilder.build();
        }
        return this.tokenValidator;
    }

    private TokenAuthenticationResult unauthenticated(HttpServletResponse httpResponse, String message) {
        logger.warn("Request could not be authenticated: {}.", (Object)message);
        try {
            httpResponse.sendError(401, message);
        }
        catch (IOException e) {
            logger.error("Could not send unauthenticated response!", (Throwable)e);
        }
        return TokenAuthenticationResult.createUnauthenticated(message);
    }

    protected TokenAuthenticationResult authenticated(Token token) {
        return TokenAuthenticationResult.createAuthenticated(Collections.emptyList(), token);
    }

    private boolean headerIsAvailable(String authorizationHeader) {
        return authorizationHeader != null && !authorizationHeader.isEmpty();
    }
}

