/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.json.DefaultJsonObject;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractToken
implements Token {
    protected final DefaultJsonObject tokenHeader;
    protected final DefaultJsonObject tokenBody;
    protected final String jwtToken;

    public AbstractToken(@Nonnull DecodedJwt decodedJwt) {
        this(decodedJwt.getHeader(), decodedJwt.getPayload(), decodedJwt.getEncodedToken());
    }

    public AbstractToken(@Nonnull String jwtToken) {
        this(Base64JwtDecoder.getInstance().decode(AbstractToken.removeBearer(jwtToken)));
    }

    AbstractToken(String jsonHeader, String jsonPayload, String jwtToken) {
        this.tokenHeader = new DefaultJsonObject(jsonHeader);
        this.tokenBody = new DefaultJsonObject(jsonPayload);
        this.jwtToken = jwtToken;
    }

    @Override
    @Nullable
    public String getHeaderParameterAsString(@Nonnull String headerName) {
        return this.tokenHeader.getAsString(headerName);
    }

    @Override
    public boolean hasClaim(@Nonnull String claimName) {
        return this.tokenBody.contains(claimName);
    }

    @Override
    public boolean hasHeaderParameter(@Nonnull String parameterName) {
        return this.tokenHeader.contains(parameterName);
    }

    @Override
    @Nullable
    public String getClaimAsString(@Nonnull String claimName) {
        return this.tokenBody.getAsString(claimName);
    }

    @Override
    @Nullable
    public List<String> getClaimAsStringList(@Nonnull String claimName) {
        return this.tokenBody.getAsList(claimName, String.class);
    }

    @Override
    @Nullable
    public JsonObject getClaimAsJsonObject(String claimName) {
        return this.tokenBody.getJsonObject(claimName);
    }

    @Override
    @Nullable
    public Instant getExpiration() {
        return this.tokenBody.getAsInstant("exp");
    }

    @Override
    public boolean isExpired() {
        return this.getExpiration() == null ? true : this.getExpiration().isBefore(LocalDateTime.now().toInstant(ZoneOffset.UTC));
    }

    @Override
    @Nullable
    public Instant getNotBefore() {
        return this.tokenBody.contains("nbf") ? this.tokenBody.getAsInstant("nbf") : this.tokenBody.getAsInstant("iat");
    }

    @Override
    public String getTokenValue() {
        return this.jwtToken;
    }

    @Override
    public Set<String> getAudiences() {
        LinkedHashSet<String> audiences = new LinkedHashSet<String>();
        audiences.addAll(this.getClaimAsStringList("aud"));
        return audiences;
    }

    protected Principal createPrincipalByName(final String name) {
        return new Principal(){

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Principal)) {
                    return false;
                }
                Principal that = (Principal)o;
                return this.getName().equals(that.getName());
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.getName());
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    private static String removeBearer(@Nonnull String jwtToken) {
        Assertions.assertHasText((String)jwtToken, (String)"jwtToken must not be null / empty");
        Pattern bearerPattern = Pattern.compile("[B|b]earer ");
        return bearerPattern.matcher(jwtToken).replaceFirst("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractToken)) {
            return false;
        }
        AbstractToken that = (AbstractToken)o;
        return this.getTokenValue().equals(that.getTokenValue());
    }

    public int hashCode() {
        return Objects.hash(this.getTokenValue());
    }
}

