/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.Token;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContext.class);
    private static final ThreadLocal<Token> tokenStorage = new ThreadLocal();

    private SecurityContext() {
    }

    public static void setToken(Token token) {
        LOGGER.info("Sets token of service {} to SecurityContext (thread-locally).", token != null ? token.getService() : "null");
        tokenStorage.set(token);
    }

    @Nullable
    public static Token getToken() {
        return tokenStorage.get();
    }

    @Nullable
    public static AccessToken getAccessToken() {
        return tokenStorage.get() instanceof AccessToken ? (AccessToken)tokenStorage.get() : null;
    }

    public static void clearToken() {
        tokenStorage.remove();
    }
}

