/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.adapter.spring;

import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaScopeConverter;
import com.sap.cloud.security.token.XsuaaToken;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.token.validation.validators.JwtValidatorBuilder;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import com.sap.cloud.security.xsuaa.client.SpringOAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.client.SpringOidcConfigurationService;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class SAPOfflineTokenServicesCloud
implements ResourceServerTokenServices,
InitializingBean {
    private final OAuth2ServiceConfiguration serviceConfiguration;
    private Validator<Token> tokenValidator;
    private JwtValidatorBuilder jwtValidatorBuilder;
    private boolean useLocalScopeAsAuthorities;
    private ScopeConverter xsuaaScopeConverter;

    public SAPOfflineTokenServicesCloud() {
        this(Environments.getCurrent().getXsuaaConfiguration());
    }

    public SAPOfflineTokenServicesCloud(OAuth2ServiceConfiguration serviceConfiguration) {
        this(serviceConfiguration, (RestOperations)new RestTemplate());
    }

    public SAPOfflineTokenServicesCloud(OAuth2ServiceConfiguration serviceConfiguration, RestOperations restOperations) {
        this(serviceConfiguration, JwtValidatorBuilder.getInstance(serviceConfiguration).withOAuth2TokenKeyService((OAuth2TokenKeyService)new SpringOAuth2TokenKeyService(restOperations)).withOidcConfigurationService((OidcConfigurationService)new SpringOidcConfigurationService(restOperations)));
    }

    SAPOfflineTokenServicesCloud(OAuth2ServiceConfiguration serviceConfiguration, JwtValidatorBuilder jwtValidatorBuilder) {
        Assertions.assertNotNull((Object)serviceConfiguration, (String)"serviceConfiguration is required.");
        Assertions.assertNotNull((Object)jwtValidatorBuilder, (String)"jwtValidatorBuilder is required.");
        this.serviceConfiguration = serviceConfiguration;
        this.jwtValidatorBuilder = jwtValidatorBuilder;
        if (serviceConfiguration.hasProperty("xsappname")) {
            this.xsuaaScopeConverter = new XsuaaScopeConverter(serviceConfiguration.getProperty("xsappname"));
        }
    }

    public OAuth2Authentication loadAuthentication(@Nonnull String accessToken) throws AuthenticationException, InvalidTokenException {
        ValidationResult validationResult;
        Set<String> scopes;
        Token token = this.checkAndCreateToken(accessToken);
        Set<String> set = scopes = token instanceof AccessToken ? ((AccessToken)token).getScopes() : Collections.emptySet();
        if (this.useLocalScopeAsAuthorities) {
            scopes = this.xsuaaScopeConverter.convert(scopes);
        }
        if ((validationResult = this.tokenValidator.validate(token)).isValid()) {
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(new HashMap(), null, this.serviceConfiguration.getClientId(), scopes.stream().collect(Collectors.toSet()), new HashSet(), null, true, "", "", null);
            SecurityContext.setToken(token);
            return new OAuth2Authentication(authorizationRequest.createOAuth2Request(), null);
        }
        throw new InvalidTokenException(validationResult.getErrorDescription());
    }

    public void afterPropertiesSet() {
        this.tokenValidator = this.jwtValidatorBuilder.build();
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: readAccessToken()");
    }

    public SAPOfflineTokenServicesCloud setLocalScopeAsAuthorities(boolean extractLocalScopesOnly) {
        this.useLocalScopeAsAuthorities = extractLocalScopesOnly;
        return this;
    }

    private Token checkAndCreateToken(@Nonnull String accessToken) {
        try {
            switch (this.serviceConfiguration.getService()) {
                case XSUAA: {
                    return new XsuaaToken(accessToken).withScopeConverter(this.xsuaaScopeConverter);
                }
            }
            throw new InvalidTokenException("AccessToken of service " + (Object)((Object)this.serviceConfiguration.getService()) + " is not supported.");
        }
        catch (Exception e) {
            throw new InvalidTokenException(e.getMessage());
        }
    }
}

