/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.xsuaa.Assertions;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class OAuth2ServiceConfigurationBuilder {
    private Service service;
    private boolean runInLegacyMode;
    private final Map<String, String> properties = new HashMap<String, String>();

    private OAuth2ServiceConfigurationBuilder() {
    }

    public static OAuth2ServiceConfigurationBuilder forService(@Nonnull Service service) {
        Assertions.assertNotNull((Object)((Object)service), (String)"Service must not be null!");
        OAuth2ServiceConfigurationBuilder instance = new OAuth2ServiceConfigurationBuilder();
        instance.service = service;
        return instance;
    }

    public OAuth2ServiceConfigurationBuilder withClientId(String clientId) {
        this.properties.put("clientid", clientId);
        return this;
    }

    public OAuth2ServiceConfigurationBuilder withClientSecret(String clientSecret) {
        this.properties.put("clientsecret", clientSecret);
        return this;
    }

    public OAuth2ServiceConfigurationBuilder withUrl(String url) {
        this.properties.put("url", url);
        return this;
    }

    public OAuth2ServiceConfigurationBuilder withProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public OAuth2ServiceConfigurationBuilder withProperties(Map<String, String> properties) {
        properties.forEach((key, value) -> this.withProperty((String)key, (String)value));
        return this;
    }

    public OAuth2ServiceConfigurationBuilder runInLegacyMode(boolean isLegacyMode) {
        if (isLegacyMode && !this.service.equals((Object)Service.XSUAA)) {
            throw new UnsupportedOperationException("Legacy Mode is not supported for Service " + (Object)((Object)this.service));
        }
        this.runInLegacyMode = isLegacyMode;
        return this;
    }

    public OAuth2ServiceConfiguration build() {
        return new OAuth2ServiceConfiguration(){

            @Override
            public String getClientId() {
                return (String)OAuth2ServiceConfigurationBuilder.this.properties.get("clientid");
            }

            @Override
            public String getClientSecret() {
                return (String)OAuth2ServiceConfigurationBuilder.this.properties.get("clientsecret");
            }

            @Override
            public URI getUrl() {
                return URI.create((String)OAuth2ServiceConfigurationBuilder.this.properties.get("url"));
            }

            @Override
            public String getProperty(String name) {
                return (String)OAuth2ServiceConfigurationBuilder.this.properties.get(name);
            }

            @Override
            public boolean hasProperty(String name) {
                return OAuth2ServiceConfigurationBuilder.this.properties.containsKey(name);
            }

            @Override
            public Service getService() {
                return OAuth2ServiceConfigurationBuilder.this.service;
            }

            @Override
            public boolean isLegacyMode() {
                return OAuth2ServiceConfigurationBuilder.this.runInLegacyMode;
            }
        };
    }
}

