/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config.cf;

import com.sap.cloud.security.config.Environment;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.config.cf.CFConstants;
import com.sap.cloud.security.config.cf.CFEnvParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public class CFEnvironment
implements Environment {
    private Map<Service, List<OAuth2ServiceConfiguration>> serviceConfigurations;
    private UnaryOperator<String> systemEnvironmentProvider;
    private UnaryOperator<String> systemPropertiesProvider;

    private CFEnvironment() {
    }

    public static CFEnvironment getInstance() {
        return CFEnvironment.getInstance(System::getenv, System::getProperty);
    }

    static CFEnvironment getInstance(UnaryOperator<String> systemEnvironmentProvider, UnaryOperator<String> systemPropertiesProvider) {
        CFEnvironment instance = new CFEnvironment();
        instance.systemEnvironmentProvider = systemEnvironmentProvider;
        instance.systemPropertiesProvider = systemPropertiesProvider;
        instance.serviceConfigurations = CFEnvParser.loadAll(instance.extractVcapServicesJson(), instance.extractVcapApplicationJson());
        return instance;
    }

    @Override
    public OAuth2ServiceConfiguration getXsuaaConfiguration() {
        return this.loadXsuaa();
    }

    @Nullable
    public OAuth2ServiceConfiguration getIasConfiguration() {
        throw new UnsupportedOperationException("Bindings of IAS Identity Service is not yet supported.");
    }

    @Override
    public int getNumberOfXsuaaConfigurations() {
        return this.loadAllForService(Service.XSUAA).size();
    }

    @Override
    public OAuth2ServiceConfiguration getXsuaaConfigurationForTokenExchange() {
        if (this.getNumberOfXsuaaConfigurations() > 1) {
            return this.loadForServicePlan(Service.XSUAA, CFConstants.Plan.BROKER);
        }
        return this.getXsuaaConfiguration();
    }

    List<OAuth2ServiceConfiguration> loadAllForService(Service service) {
        return this.serviceConfigurations.getOrDefault((Object)service, Collections.emptyList());
    }

    @Override
    public Environment.Type getType() {
        return Environment.Type.CF;
    }

    private String extractVcapServicesJson() {
        String env = (String)this.systemPropertiesProvider.apply("VCAP_SERVICES");
        if (env == null) {
            env = (String)this.systemEnvironmentProvider.apply("VCAP_SERVICES");
        }
        return env != null ? env : "{}";
    }

    private String extractVcapApplicationJson() {
        String env = System.getenv("VCAP_APPLICATION");
        return env != null ? env : "{}";
    }

    private OAuth2ServiceConfiguration loadXsuaa() {
        Optional<OAuth2ServiceConfiguration> applicationService = Optional.ofNullable(this.loadForServicePlan(Service.XSUAA, CFConstants.Plan.APPLICATION));
        Optional<OAuth2ServiceConfiguration> brokerService = Optional.ofNullable(this.loadForServicePlan(Service.XSUAA, CFConstants.Plan.BROKER));
        Optional<OAuth2ServiceConfiguration> legacyService = Optional.ofNullable(this.loadForServicePlan(Service.XSUAA, CFConstants.Plan.SPACE));
        if (applicationService.isPresent()) {
            return applicationService.get();
        }
        return brokerService.orElse(legacyService.orElse(null));
    }

    @Nullable
    public OAuth2ServiceConfiguration loadForServicePlan(Service service, CFConstants.Plan plan) {
        return this.loadAllForService(service).stream().filter(configuration -> CFConstants.Plan.from(configuration.getProperty("plan")).equals((Object)plan)).findFirst().orElse(null);
    }
}

