/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.Assertions;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAudienceValidator
implements Validator<Token> {
    private static final Logger logger = LoggerFactory.getLogger(JwtAudienceValidator.class);
    private static final char DOT = '.';
    private final Set<String> clientIds = new LinkedHashSet<String>();

    JwtAudienceValidator(String clientId) {
        this.configureTrustedClientId(clientId);
    }

    JwtAudienceValidator configureTrustedClientId(String clientId) {
        Assertions.assertHasText((String)clientId, (String)"JwtAudienceValidator requires a clientId.");
        this.clientIds.add(clientId);
        logger.info("configured JwtAudienceValidator with clientId {}.", (Object)clientId);
        return this;
    }

    @Override
    public ValidationResult validate(Token token) {
        Set<String> allowedAudiences = JwtAudienceValidator.getAllowedAudiences(token);
        for (String configuredClientId : this.clientIds) {
            if (!allowedAudiences.contains(configuredClientId)) continue;
            return ValidationResults.createValid();
        }
        return ValidationResults.createInvalid("Jwt token with audience {} is not issued for these clientIds: {}.", allowedAudiences, this.clientIds);
    }

    static Set<String> getAllowedAudiences(Token token) {
        LinkedHashSet<String> audiences = new LinkedHashSet<String>();
        for (String audience : token.getAudiences()) {
            if (audience.contains(".")) {
                String aud = audience.substring(0, audience.indexOf(46)).trim();
                if (aud.isEmpty()) continue;
                audiences.add(aud);
                continue;
            }
            audiences.add(audience);
        }
        return audiences;
    }
}

