/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.adapter.spring;

import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaToken;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;

public class SpringSecurityContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringSecurityContext.class);

    private SpringSecurityContext() {
    }

    @Nullable
    public static Token getToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.nonNull(authentication) && authentication.isAuthenticated() && authentication.getDetails() instanceof OAuth2AuthenticationDetails) {
            OAuth2AuthenticationDetails authDetails = (OAuth2AuthenticationDetails)authentication.getDetails();
            String tokenValue = authDetails.getTokenValue();
            return new XsuaaToken(tokenValue);
        }
        return null;
    }

    @Nullable
    public static AccessToken getAccessToken() {
        Token token = SpringSecurityContext.getToken();
        return token instanceof AccessToken ? (AccessToken)token : null;
    }

    public static void clear() {
        SecurityContextHolder.clearContext();
    }
}

