/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.Assertions;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public class TokenAuthenticationResult {
    private Collection<String> scopes = Collections.emptyList();
    private Token token = null;
    private String reason = "";

    private TokenAuthenticationResult() {
    }

    public static final TokenAuthenticationResult createUnauthenticated(String reason) {
        Assertions.assertHasText((String)reason, (String)"Reason must contain text");
        TokenAuthenticationResult result = new TokenAuthenticationResult();
        result.reason = reason;
        return result;
    }

    public static TokenAuthenticationResult createAuthenticated(Collection<String> scopes, Token token) {
        TokenAuthenticationResult result = new TokenAuthenticationResult();
        result.scopes = scopes;
        result.token = token;
        return result;
    }

    @Nullable
    public Token getToken() {
        return this.token;
    }

    @Nullable
    public Principal getPrincipal() {
        return this.token.getPrincipal();
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public boolean isAuthenticated() {
        return this.reason.isEmpty();
    }

    public String getUnauthenticatedReason() {
        return this.reason;
    }
}

