/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.adapter.xs;

import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.json.JsonParsingException;
import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.GrantType;
import com.sap.cloud.security.token.Token;
import com.sap.xsa.security.container.XSTokenRequest;
import com.sap.xsa.security.container.XSUserInfo;
import com.sap.xsa.security.container.XSUserInfoException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSUserInfoAdapter
implements XSUserInfo {
    static final String EXTERNAL_CONTEXT = "ext_ctx";
    static final String CLAIM_ADDITIONAL_AZ_ATTR = "az_attr";
    static final String XS_USER_ATTRIBUTES = "xs.user.attributes";
    static final String XS_SYSTEM_ATTRIBUTES = "xs.system.attributes";
    static final String HDB_NAMEDUSER_SAML = "hdb.nameduser.saml";
    static final String SERVICEINSTANCEID = "serviceinstanceid";
    static final String ZDN = "zdn";
    static final String SYSTEM = "SYSTEM";
    static final String HDB = "HDB";
    private static final Logger LOGGER = LoggerFactory.getLogger(XSUserInfoAdapter.class);
    private final AccessToken accessToken;
    private OAuth2ServiceConfiguration configuration;

    public XSUserInfoAdapter(Token accessToken) throws XSUserInfoException {
        this(accessToken, Environments.getCurrent().getXsuaaConfiguration());
    }

    public XSUserInfoAdapter(AccessToken accessToken) throws XSUserInfoException {
        if (accessToken == null) {
            throw new XSUserInfoException("token must not be null.");
        }
        this.accessToken = accessToken;
    }

    XSUserInfoAdapter(Token accessToken, OAuth2ServiceConfiguration configuration) throws XSUserInfoException {
        if (!(accessToken instanceof AccessToken)) {
            throw new XSUserInfoException("token is of instance " + accessToken.getClass().getName() + " but needs to be an instance of XsuaaToken.");
        }
        this.accessToken = (AccessToken)accessToken;
        this.configuration = configuration;
    }

    public String getLogonName() throws XSUserInfoException {
        this.checkNotGrantTypeClientCredentials("getLogonName");
        return this.getClaimValue("user_name");
    }

    public String getGivenName() throws XSUserInfoException {
        this.checkNotGrantTypeClientCredentials("getGivenName");
        String externalAttributeName = this.getExternalAttribute("given_name");
        if (externalAttributeName == null) {
            return this.getClaimValue("given_name");
        }
        return externalAttributeName;
    }

    public String getFamilyName() throws XSUserInfoException {
        this.checkNotGrantTypeClientCredentials("getFamilyName");
        String externalAttributeName = this.getExternalAttribute("family_name");
        if (externalAttributeName == null) {
            return this.getClaimValue("family_name");
        }
        return externalAttributeName;
    }

    public String getOrigin() throws XSUserInfoException {
        this.checkNotGrantTypeClientCredentials("getOrigin");
        return this.getClaimValue("origin");
    }

    public String getIdentityZone() throws XSUserInfoException {
        return this.getClaimValue("zid");
    }

    public String getSubaccountId() throws XSUserInfoException {
        return this.getIdentityZone();
    }

    public String getSubdomain() throws XSUserInfoException {
        return Optional.ofNullable(this.getExternalAttribute(ZDN)).orElse(null);
    }

    public String getClientId() throws XSUserInfoException {
        return this.getClaimValue("cid");
    }

    public String getJsonValue(String attribute) throws XSUserInfoException {
        return this.getClaimValue(attribute);
    }

    public String getEmail() throws XSUserInfoException {
        this.checkNotGrantTypeClientCredentials("getEmail");
        return this.getClaimValue("email");
    }

    public String getDBToken() throws XSUserInfoException {
        return this.getHdbToken();
    }

    public String getHdbToken() throws XSUserInfoException {
        return this.getToken(SYSTEM, HDB);
    }

    public String getAppToken() {
        return this.accessToken.getTokenValue();
    }

    public String getToken(String namespace, String name) throws XSUserInfoException {
        if (!this.getGrantType().equals(GrantType.CLIENT_CREDENTIALS.toString()) && this.hasAttributes() && this.isInForeignMode()) {
            throw new XSUserInfoException("The SecurityContext has been initialized with an access token of a\nforeign OAuth Client Id and/or Identity Zone. Furthermore, the\naccess token contains attributes. Due to the fact that we want to\nrestrict attribute access to the application that provided the \nattributes, the getToken function does not return a valid token");
        }
        if (!namespace.equals(SYSTEM)) {
            throw new XSUserInfoException("Invalid namespace " + namespace);
        }
        if (name.equals(HDB)) {
            String token = this.accessToken.hasClaim(EXTERNAL_CONTEXT) ? this.getAttributeFromClaimAsString(EXTERNAL_CONTEXT, HDB_NAMEDUSER_SAML) : this.accessToken.getClaimAsString(HDB_NAMEDUSER_SAML);
            if (token == null) {
                token = this.accessToken.getTokenValue();
            }
            return token;
        }
        if (name.equals("JobScheduler")) {
            return this.accessToken.getTokenValue();
        }
        throw new XSUserInfoException("Invalid name " + name + " for namespace " + namespace);
    }

    public String[] getAttribute(String attributeName) throws XSUserInfoException {
        this.checkNotGrantTypeClientCredentials("getAttribute");
        return this.getMultiValueAttributeFromExtObject(XS_USER_ATTRIBUTES, attributeName);
    }

    public boolean hasAttributes() throws XSUserInfoException {
        this.checkNotGrantTypeClientCredentials("hasAttributes");
        if (this.accessToken.hasClaim(EXTERNAL_CONTEXT)) {
            JsonObject extContext = this.getClaimAsJsonObject(EXTERNAL_CONTEXT);
            return extContext != null && extContext.contains(XS_USER_ATTRIBUTES) && !extContext.getJsonObject(EXTERNAL_CONTEXT).isEmpty();
        }
        JsonObject xsUserAttributes = this.getClaimAsJsonObject(XS_USER_ATTRIBUTES);
        return xsUserAttributes != null && !xsUserAttributes.isEmpty();
    }

    public String[] getSystemAttribute(String attributeName) throws XSUserInfoException {
        return this.getMultiValueAttributeFromExtObject(XS_SYSTEM_ATTRIBUTES, attributeName);
    }

    public boolean checkScope(String scope) throws XSUserInfoException {
        return this.accessToken.hasScope(scope);
    }

    public boolean checkLocalScope(String scope) throws XSUserInfoException {
        try {
            return this.accessToken.hasLocalScope(scope);
        }
        catch (IllegalArgumentException e) {
            throw new XSUserInfoException(e.getMessage());
        }
    }

    public String getAdditionalAuthAttribute(String attributeName) throws XSUserInfoException {
        return Optional.ofNullable(this.getAttributeFromClaimAsString(CLAIM_ADDITIONAL_AZ_ATTR, attributeName)).orElseThrow(this.createXSUserInfoException(attributeName));
    }

    public String getCloneServiceInstanceId() throws XSUserInfoException {
        return Optional.ofNullable(this.getExternalAttribute(SERVICEINSTANCEID)).orElseThrow(this.createXSUserInfoException(SERVICEINSTANCEID));
    }

    public String getGrantType() throws XSUserInfoException {
        return Optional.ofNullable(this.accessToken.getGrantType()).map(GrantType::toString).orElseThrow(this.createXSUserInfoException("grant_type"));
    }

    public boolean isInForeignMode() {
        String tokenIdentityZone;
        String tokenClientId;
        if (this.configuration == null) {
            LOGGER.info("No configuration provided -> falling back to foreignMode = true!");
            return true;
        }
        try {
            tokenClientId = this.getClientId();
            tokenIdentityZone = this.getIdentityZone();
        }
        catch (XSUserInfoException e) {
            LOGGER.warn("Tried to access missing attribute when checking for foreign mode", (Throwable)e);
            return true;
        }
        boolean clientIdsMatch = tokenClientId.equals(this.configuration.getClientId());
        boolean identityZonesMatch = tokenIdentityZone.equals(this.configuration.getProperty("identityzone"));
        boolean isApplicationPlan = tokenClientId.contains("!t");
        if (clientIdsMatch && (identityZonesMatch || isApplicationPlan)) {
            LOGGER.info("Token not in foreign mode because because client ids  match and identityZonesMatch={}, isApplicationPlan={} ", (Object)identityZonesMatch, (Object)isApplicationPlan);
            return false;
        }
        String bindingTrustedClientIdSuffix = this.configuration.getProperty("trustedclientidsuffix");
        if (bindingTrustedClientIdSuffix != null && tokenClientId.endsWith(bindingTrustedClientIdSuffix)) {
            LOGGER.info("Token not in foreign mode because token client id matches binding trusted client suffix");
            return false;
        }
        LOGGER.info("Token in foreign mode: clientIdsMatch={}, identityZonesMatch={}, isApplicationPlan={}, bindingTrustedClientIdSuffix={}", new Object[]{clientIdsMatch, identityZonesMatch, isApplicationPlan, bindingTrustedClientIdSuffix});
        return true;
    }

    public String requestTokenForClient(String clientId, String clientSecret, String uaaUrl) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String requestToken(XSTokenRequest tokenRequest) throws XSUserInfoException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    private String[] getMultiValueAttributeFromExtObject(String claimName, String attributeName) throws XSUserInfoException {
        JsonObject claimAsJsonObject = this.getClaimAsJsonObject(claimName);
        return Optional.ofNullable(claimAsJsonObject).map(jsonObject -> jsonObject.getAsList(attributeName, String.class)).map(values -> values.toArray(new String[0])).orElseThrow(this.createXSUserInfoException(attributeName));
    }

    private void checkNotGrantTypeClientCredentials(String methodName) throws XSUserInfoException {
        if (GrantType.CLIENT_CREDENTIALS == this.accessToken.getGrantType()) {
            String message = String.format("Method '%s' is not supported for grant type '%s'", methodName, GrantType.CLIENT_CREDENTIALS);
            throw new XSUserInfoException(message + GrantType.CLIENT_CREDENTIALS);
        }
    }

    @Nullable
    private String getAttributeFromClaimAsString(String claimName, String attributeName) throws XSUserInfoException {
        return Optional.ofNullable(this.getClaimAsJsonObject(claimName)).map(claim -> claim.getAsString(attributeName)).orElse(null);
    }

    private Supplier<XSUserInfoException> createXSUserInfoException(String attribute) {
        return () -> new XSUserInfoException("Invalid user attribute " + attribute);
    }

    private String getClaimValue(String claimname) throws XSUserInfoException {
        String value = this.accessToken.getClaimAsString(claimname);
        if (value == null) {
            throw new XSUserInfoException("Invalid user attribute " + claimname);
        }
        return value;
    }

    @Nullable
    private JsonObject getClaimAsJsonObject(String claimName) throws XSUserInfoException {
        try {
            return this.accessToken.getClaimAsJsonObject(claimName);
        }
        catch (JsonParsingException e) {
            throw this.createXSUserInfoException(claimName).get();
        }
    }

    String getExternalAttribute(String attributeName) throws XSUserInfoException {
        return this.getAttributeFromClaimAsString("ext_attr", attributeName);
    }
}

