/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.token.AbstractToken;
import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.GrantType;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.security.Principal;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class XsuaaToken
extends AbstractToken
implements AccessToken {
    static final String UNIQUE_USER_NAME_FORMAT = "user/%s/%s";
    static final String UNIQUE_CLIENT_NAME_FORMAT = "client/%s";
    private ScopeConverter scopeConverter;

    public XsuaaToken(@Nonnull DecodedJwt decodedJwt) {
        super(decodedJwt);
    }

    public XsuaaToken(@Nonnull String accessToken) {
        super(accessToken);
    }

    public XsuaaToken withScopeConverter(@Nullable ScopeConverter converter) {
        this.scopeConverter = converter;
        return this;
    }

    static String getUniquePrincipalName(String origin, String userLoginName) {
        Assertions.assertHasText((String)origin, (String)"Origin claim not set in JWT. Cannot create unique user name. Returning null.");
        Assertions.assertHasText((String)userLoginName, (String)"User login name claim not set in JWT. Cannot create unique user name. Returning null.");
        if (origin.contains("/")) {
            throw new IllegalArgumentException("Illegal '/' character detected in origin claim of JWT. Cannot create unique user name. Returing null.");
        }
        return String.format(UNIQUE_USER_NAME_FORMAT, origin, userLoginName);
    }

    public Set<String> getScopes() {
        LinkedHashSet<String> scopes = new LinkedHashSet<String>();
        scopes.addAll(this.getClaimAsStringList("scope"));
        return scopes;
    }

    public Principal getPrincipal() {
        String principalName;
        switch (this.getGrantType()) {
            case CLIENT_CREDENTIALS: 
            case CLIENT_X509: {
                principalName = String.format(UNIQUE_CLIENT_NAME_FORMAT, this.getClaimAsString("cid"));
                break;
            }
            default: {
                principalName = XsuaaToken.getUniquePrincipalName(this.getClaimAsString("origin"), this.getClaimAsString("user_name"));
            }
        }
        return this.createPrincipalByName(principalName);
    }

    public Service getService() {
        return Service.XSUAA;
    }

    public boolean hasScope(String scope) {
        return this.getScopes().contains(scope);
    }

    public boolean hasLocalScope(@Nonnull String scope) {
        Assertions.assertNotNull((Object)this.scopeConverter, (String)"hasLocalScope() method requires a scopeConverter, which must not be null");
        return this.scopeConverter.convert(this.getScopes()).contains(scope);
    }

    public GrantType getGrantType() {
        return GrantType.from((String)this.getClaimAsString("grant_type"));
    }
}

