/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.sap.cloud.security.token.validation.validators.JsonWebKey;
import com.sap.cloud.security.token.validation.validators.JsonWebKeyImpl;
import com.sap.cloud.security.token.validation.validators.JsonWebKeySet;
import com.sap.cloud.security.token.validation.validators.JsonWebKeySetFactory;
import com.sap.cloud.security.token.validation.validators.JwtSignatureAlgorithm;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class OAuth2TokenKeyServiceWithCache {
    private OAuth2TokenKeyService tokenKeyService;
    private Cache<String, PublicKey> cache;
    private long cacheValidityInSeconds = 600L;
    private long cacheSize = 1000L;

    private OAuth2TokenKeyServiceWithCache() {
    }

    public static OAuth2TokenKeyServiceWithCache getInstance() {
        OAuth2TokenKeyServiceWithCache instance = new OAuth2TokenKeyServiceWithCache();
        return instance;
    }

    public OAuth2TokenKeyServiceWithCache withCacheTime(int timeInSeconds) {
        if (timeInSeconds <= 600) {
            throw new IllegalArgumentException("The cache validity must be minimum 600 seconds");
        }
        this.cacheValidityInSeconds = timeInSeconds;
        return this;
    }

    public OAuth2TokenKeyServiceWithCache withCacheSize(int size) {
        if (size <= 1000) {
            throw new IllegalArgumentException("The cache size must be 1000 or more");
        }
        this.cacheSize = size;
        return this;
    }

    public OAuth2TokenKeyServiceWithCache withTokenKeyService(OAuth2TokenKeyService tokenKeyService) {
        this.tokenKeyService = tokenKeyService;
        return this;
    }

    @Nullable
    public PublicKey getPublicKey(JwtSignatureAlgorithm keyAlgorithm, String keyId, URI keyUri) throws OAuth2ServiceException, InvalidKeySpecException, NoSuchAlgorithmException {
        Assertions.assertNotNull((Object)((Object)keyAlgorithm), (String)"keyAlgorithm must not be null.");
        Assertions.assertHasText((String)keyId, (String)"keyId must not be null.");
        Assertions.assertNotNull((Object)keyUri, (String)"keyUrl must not be null.");
        String cacheKey = OAuth2TokenKeyServiceWithCache.getUniqueCacheKey(keyAlgorithm, keyId, keyUri);
        PublicKey publicKey = (PublicKey)this.getCache().getIfPresent((Object)cacheKey);
        if (publicKey == null) {
            this.retrieveTokenKeysAndFillCache(keyUri);
        }
        return (PublicKey)this.getCache().getIfPresent((Object)cacheKey);
    }

    private void retrieveTokenKeysAndFillCache(URI jwksUri) throws OAuth2ServiceException, InvalidKeySpecException, NoSuchAlgorithmException {
        JsonWebKeySet keySet = JsonWebKeySetFactory.createFromJson(this.getTokenKeyService().retrieveTokenKeys(jwksUri));
        if (keySet == null) {
            return;
        }
        Set<JsonWebKey> jwks = keySet.getAll();
        for (JsonWebKey jwk : jwks) {
            this.getCache().put((Object)OAuth2TokenKeyServiceWithCache.getUniqueCacheKey(jwk.getKeyAlgorithm(), jwk.getId(), jwksUri), (Object)jwk.getPublicKey());
        }
    }

    private Cache<String, PublicKey> getCache() {
        if (this.cache == null) {
            this.cache = Caffeine.newBuilder().expireAfterWrite(this.cacheValidityInSeconds, TimeUnit.SECONDS).maximumSize(this.cacheSize).build();
        }
        return this.cache;
    }

    private OAuth2TokenKeyService getTokenKeyService() {
        if (this.tokenKeyService == null) {
            this.tokenKeyService = new DefaultOAuth2TokenKeyService();
        }
        return this.tokenKeyService;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    public static String getUniqueCacheKey(JwtSignatureAlgorithm keyAlgorithm, String keyId, URI jwksUri) {
        return jwksUri + String.valueOf(JsonWebKeyImpl.calculateUniqueId(keyAlgorithm, keyId));
    }
}

