/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.servlet.AbstractTokenAuthenticator;
import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.servlet.TokenAuthenticatorResult;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaScopeConverter;
import com.sap.cloud.security.token.XsuaaToken;
import java.util.Set;

public class XsuaaTokenAuthenticator
extends AbstractTokenAuthenticator {
    @Override
    public Token extractFromHeader(String authorizationHeader) {
        return new XsuaaToken(authorizationHeader).withScopeConverter(this.getScopeConverter());
    }

    @Override
    protected OAuth2ServiceConfiguration getServiceConfiguration() {
        OAuth2ServiceConfiguration config;
        OAuth2ServiceConfiguration oAuth2ServiceConfiguration = config = this.serviceConfiguration != null ? this.serviceConfiguration : Environments.getCurrent().getXsuaaConfiguration();
        if (config == null) {
            throw new IllegalStateException("There must be a service configuration.");
        }
        return config;
    }

    @Override
    protected TokenAuthenticationResult authenticated(Token token) {
        Set<String> translatedScopes = this.getScopeConverter().convert(((XsuaaToken)token).getScopes());
        return TokenAuthenticatorResult.createAuthenticated(translatedScopes, token);
    }

    private ScopeConverter getScopeConverter() {
        return new XsuaaScopeConverter(this.getServiceConfiguration().getProperty("xsappname"));
    }
}

