/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config.cf;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.OAuth2ServiceConfigurationBuilder;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.json.DefaultJsonObject;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.json.JsonParsingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CFEnvParser {
    private static final Logger logger = LoggerFactory.getLogger(CFEnvParser.class);

    private CFEnvParser() {
    }

    public static OAuth2ServiceConfiguration extract(Service service, JsonObject vcapServiceJson) {
        return CFEnvParser.extract(service, vcapServiceJson, false);
    }

    static Map<Service, List<OAuth2ServiceConfiguration>> loadAll(String vcapServicesJson, String vcapApplicationJson) {
        HashMap<Service, List<OAuth2ServiceConfiguration>> serviceConfigurations = new HashMap<Service, List<OAuth2ServiceConfiguration>>();
        for (Service service : Service.values()) {
            List<OAuth2ServiceConfiguration> allServices = CFEnvParser.extractAllServices(service, new DefaultJsonObject(vcapServicesJson), CFEnvParser.runInLegacyMode(vcapApplicationJson));
            serviceConfigurations.put(service, allServices);
        }
        return serviceConfigurations;
    }

    private static boolean runInLegacyMode(String vcapApplicationJson) {
        return new DefaultJsonObject(vcapApplicationJson).contains("xs_api");
    }

    static List<OAuth2ServiceConfiguration> extractAllServices(Service service, JsonObject vcapServicesJson, boolean isLegacyMode) {
        List serviceJsonObjects = vcapServicesJson.getJsonObjects(service.getCFName());
        if (service == Service.XSUAA && serviceJsonObjects.size() > 1) {
            logger.info("More than one service configuration available for service {}.", (Object)service);
        }
        return serviceJsonObjects.stream().map(serviceJsonObject -> CFEnvParser.extract(service, serviceJsonObject, isLegacyMode)).collect(Collectors.toList());
    }

    static OAuth2ServiceConfiguration extract(Service service, JsonObject serviceJsonObject, boolean isLegacyMode) {
        Map serviceBindingProperties = serviceJsonObject.getKeyValueMap();
        try {
            Map serviceBindingCredentials = serviceJsonObject.getJsonObject("credentials").getKeyValueMap();
            return OAuth2ServiceConfigurationBuilder.forService(service).withProperties(serviceBindingCredentials).withProperty("plan", (String)serviceBindingProperties.get("plan")).runInLegacyMode(isLegacyMode).build();
        }
        catch (JsonParsingException e) {
            String errDescription = "The credentials of 'VCAP_SERVICES' can not be parsed for service '" + service + "' ('" + e.getMessage() + "'). Please check the service binding.";
            logger.error(errDescription);
            throw new JsonParsingException(errDescription);
        }
    }
}

