/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.json;

import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.json.JsonParsingException;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonObject
implements JsonObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJsonObject.class);
    private JSONObject jsonObject;

    public DefaultJsonObject(String jsonString) {
        this.jsonObject = this.createJsonObject(jsonString);
    }

    public boolean contains(String key) {
        return this.getJsonObject().has(key);
    }

    public boolean isEmpty() {
        return this.getJsonObject().isEmpty();
    }

    public <T> List<T> getAsList(String name, Class<T> type) {
        return this.getJSONArray(name).map(jsonArray -> this.castToListOfType((JSONArray)jsonArray, type)).orElse(Collections.emptyList());
    }

    @Nullable
    public String getAsString(String name) {
        if (this.contains(name)) {
            try {
                return this.getJsonObject().getString(name);
            }
            catch (JSONException e) {
                throw new JsonParsingException(e.getMessage());
            }
        }
        return null;
    }

    @Nullable
    public Instant getAsInstant(String name) {
        if (this.contains(name)) {
            return this.getLong(name).map(this::convertToInstant).orElse(null);
        }
        return null;
    }

    @Nullable
    public JsonObject getJsonObject(String name) {
        if (this.contains(name)) {
            JSONObject newJsonObject;
            try {
                newJsonObject = this.getJsonObject().getJSONObject(name);
            }
            catch (JSONException e) {
                throw new JsonParsingException(e.getMessage());
            }
            return Optional.ofNullable(newJsonObject).map(Object::toString).map(DefaultJsonObject::new).orElse(null);
        }
        return null;
    }

    public List<JsonObject> getJsonObjects(String name) {
        return this.getJSONArray(name).map(this::convertToJsonObjects).orElse(new ArrayList());
    }

    public Map<String, String> getKeyValueMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keysItr = this.getJsonObject().keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            Object value = this.jsonObject.get(key);
            if (!(value instanceof String)) continue;
            map.put(key, String.valueOf(value));
        }
        return map;
    }

    public String asJsonString() {
        return this.jsonObject.toString();
    }

    private List<JsonObject> convertToJsonObjects(JSONArray jsonArray) {
        ArrayList<JsonObject> jsonObjects = new ArrayList<JsonObject>();
        jsonArray.forEach(jsonArrayObject -> {
            if (!(jsonArrayObject instanceof JSONObject)) {
                throw new JsonParsingException("Array does not only contain json objects!");
            }
            jsonObjects.add(new DefaultJsonObject(jsonArrayObject.toString()));
        });
        return jsonObjects;
    }

    private Optional<Long> getLong(String name) {
        try {
            return Optional.ofNullable(this.getJsonObject().getLong(name));
        }
        catch (JSONException e) {
            throw new JsonParsingException(e.getMessage());
        }
    }

    private Instant convertToInstant(long epochSeconds) {
        try {
            return Instant.ofEpochSecond(epochSeconds);
        }
        catch (NumberFormatException | DateTimeException e) {
            throw new JsonParsingException(e.getMessage());
        }
    }

    private <T> List<T> castToListOfType(JSONArray jsonArray, Class<T> type) {
        ArrayList<T> valuesAsList = new ArrayList<T>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.get(i);
            try {
                valuesAsList.add(type.cast(value));
                continue;
            }
            catch (ClassCastException e) {
                throw new JsonParsingException(e.getMessage());
            }
        }
        return valuesAsList;
    }

    private Optional<JSONArray> getJSONArray(String name) {
        if (this.contains(name)) {
            try {
                return Optional.ofNullable(this.getJsonObject().getJSONArray(name));
            }
            catch (JSONException e) {
                throw new JsonParsingException(e.getMessage());
            }
        }
        return Optional.empty();
    }

    private JSONObject getJsonObject() {
        return this.jsonObject;
    }

    private JSONObject createJsonObject(String jsonString) {
        try {
            JSONObject createdJsonObject = new JSONObject(jsonString);
            return createdJsonObject;
        }
        catch (JSONException e) {
            LOGGER.error("Given json string '{}' is not valid, error message: {}", (Object)jsonString, (Object)e.getMessage());
            throw new JsonParsingException(e.getMessage());
        }
    }
}

