/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.adapter.spring;

import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.SapIdToken;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaScopeConverter;
import com.sap.cloud.security.token.XsuaaToken;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.token.validation.validators.JwtValidatorBuilder;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import com.sap.cloud.security.xsuaa.client.SpringOAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.client.SpringOidcConfigurationService;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class SAPOfflineTokenServicesCloud
implements ResourceServerTokenServices,
InitializingBean {
    private final OAuth2ServiceConfiguration serviceConfiguration;
    private Validator<Token> tokenValidator;
    private JwtValidatorBuilder jwtValidatorBuilder;
    private boolean useLocalScopeAsAuthorities;
    private ScopeConverter xsuaaScopeConverter;

    public SAPOfflineTokenServicesCloud() {
        this(Environments.getCurrent().getXsuaaConfiguration());
    }

    public SAPOfflineTokenServicesCloud(OAuth2ServiceConfiguration serviceConfiguration) {
        this(serviceConfiguration, (RestOperations)new RestTemplate());
    }

    public SAPOfflineTokenServicesCloud(OAuth2ServiceConfiguration serviceConfiguration, RestOperations restOperations) {
        this(serviceConfiguration, JwtValidatorBuilder.getInstance(serviceConfiguration).withOAuth2TokenKeyService((OAuth2TokenKeyService)new SpringOAuth2TokenKeyService(restOperations)).withOidcConfigurationService((OidcConfigurationService)new SpringOidcConfigurationService(restOperations)));
    }

    SAPOfflineTokenServicesCloud(OAuth2ServiceConfiguration serviceConfiguration, JwtValidatorBuilder jwtValidatorBuilder) {
        Assertions.assertNotNull((Object)serviceConfiguration, (String)"serviceConfiguration is required.");
        Assertions.assertNotNull((Object)jwtValidatorBuilder, (String)"jwtValidatorBuilder is required.");
        this.serviceConfiguration = serviceConfiguration;
        this.jwtValidatorBuilder = jwtValidatorBuilder;
        if (serviceConfiguration.hasProperty("xsappname")) {
            this.xsuaaScopeConverter = new XsuaaScopeConverter(serviceConfiguration.getProperty("xsappname"));
        }
    }

    public SAPOfflineTokenServicesCloud withAnotherServiceConfiguration(OAuth2ServiceConfiguration otherServiceConfiguration) {
        this.jwtValidatorBuilder.configureAnotherServiceInstance(otherServiceConfiguration);
        return this;
    }

    public OAuth2Authentication loadAuthentication(@Nonnull String accessToken) throws AuthenticationException, InvalidTokenException {
        Token token = this.checkAndCreateToken(accessToken);
        ValidationResult validationResult = this.tokenValidator.validate(token);
        if (validationResult.isErroneous()) {
            throw new InvalidTokenException(validationResult.getErrorDescription());
        }
        SecurityContext.setToken((Token)token);
        return SAPOfflineTokenServicesCloud.getOAuth2Authentication(this.serviceConfiguration.getClientId(), this.getScopes(token));
    }

    static OAuth2Authentication getOAuth2Authentication(String clientId, Set<String> scopes) {
        Authentication userAuthentication = null;
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(clientId, scopes);
        authorizationRequest.setAuthorities(SAPOfflineTokenServicesCloud.getAuthorities(scopes));
        authorizationRequest.setApproved(true);
        return new OAuth2Authentication(authorizationRequest.createOAuth2Request(), userAuthentication);
    }

    private Set<String> getScopes(Token token) {
        Set<String> scopes;
        Set<String> set = scopes = token instanceof AccessToken ? ((AccessToken)token).getScopes() : Collections.emptySet();
        if (this.useLocalScopeAsAuthorities) {
            scopes = this.xsuaaScopeConverter.convert((Collection<String>)scopes);
        }
        return scopes;
    }

    public void afterPropertiesSet() {
        this.tokenValidator = this.jwtValidatorBuilder.build();
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: readAccessToken()");
    }

    public SAPOfflineTokenServicesCloud setLocalScopeAsAuthorities(boolean extractLocalScopesOnly) {
        this.useLocalScopeAsAuthorities = extractLocalScopesOnly;
        return this;
    }

    private static Set<GrantedAuthority> getAuthorities(Collection<String> scopes) {
        return scopes.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
    }

    private Token checkAndCreateToken(@Nonnull String accessToken) {
        try {
            switch (this.serviceConfiguration.getService()) {
                case XSUAA: {
                    return new XsuaaToken(accessToken).withScopeConverter(this.xsuaaScopeConverter);
                }
                case IAS: {
                    return new SapIdToken(accessToken);
                }
            }
            throw new InvalidTokenException("AccessToken of service " + this.serviceConfiguration.getService() + " is not supported.");
        }
        catch (Exception e) {
            throw new InvalidTokenException(e.getMessage());
        }
    }
}

