/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

public enum JwtSignatureAlgorithm {
    RS256("RSA", "RS256", "SHA256withRSA");

    private final String type;
    private final String value;
    private final String javaSignatureAlgorithm;

    private JwtSignatureAlgorithm(String type, String algorithm, String javaSignatureAlgorithm) {
        this.type = type;
        this.value = algorithm;
        this.javaSignatureAlgorithm = javaSignatureAlgorithm;
    }

    public String value() {
        return this.value;
    }

    public String javaSignature() {
        return this.javaSignatureAlgorithm;
    }

    public String type() {
        return this.type;
    }

    public static JwtSignatureAlgorithm fromValue(String value) {
        for (JwtSignatureAlgorithm algorithm : JwtSignatureAlgorithm.values()) {
            if (!algorithm.value.equals(value)) continue;
            return algorithm;
        }
        return null;
    }

    public static JwtSignatureAlgorithm fromType(String type) {
        for (JwtSignatureAlgorithm algorithm : JwtSignatureAlgorithm.values()) {
            if (!algorithm.type.equals(type)) continue;
            return algorithm;
        }
        return null;
    }
}

