/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.Assertions;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JwtIssuerValidator
implements Validator<Token> {
    private final URI url;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    JwtIssuerValidator(URI url) {
        Assertions.assertNotNull((Object)url, (String)"JwtIssuerValidator requires a url.");
        this.url = url;
    }

    @Override
    public ValidationResult validate(Token token) {
        String issuer = token.getClaimAsString("iss");
        if (issuer == null || issuer.trim().isEmpty()) {
            return ValidationResults.createInvalid("Issuer validation can not be performed because Jwt token does not contain 'iss' claim.");
        }
        return this.matchesTokenIssuerUrl(issuer);
    }

    private ValidationResult matchesTokenIssuerUrl(String issuer) {
        try {
            if (!issuer.startsWith("http")) {
                return ValidationResults.createInvalid("Issuer is not trusted because 'iss' claim '{}' does not provide a valid URI (missing http scheme). Please contact your Identity Provider Administrator.", issuer);
            }
            URI issuerUri = new URI(issuer);
            if (issuerUri.getHost() != null && issuerUri.getHost().endsWith(this.url.getHost())) {
                return ValidationResults.createValid();
            }
        }
        catch (URISyntaxException e) {
            this.logger.error("Error: 'iss' claim '{}' does not provide a valid URI: {}.", new Object[]{issuer, e.getMessage(), e});
        }
        return ValidationResults.createInvalid("Issuer is not trusted because 'iss' '{}' does not match host '{}' of the identity provider.", issuer, this.url.getHost());
    }
}

