/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.Assertions;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XsuaaJwtIssuerValidator
implements Validator<Token> {
    private final String domain;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    XsuaaJwtIssuerValidator(String uaaDomain) {
        Assertions.assertHasText((String)uaaDomain, (String)"XsuaaJwtIssuerValidator requires uaaDomain.");
        this.domain = uaaDomain;
    }

    @Override
    public ValidationResult validate(Token token) {
        String tokenKeyUrl = token.getHeaderParameterAsString("jku");
        if (tokenKeyUrl == null || tokenKeyUrl.trim().isEmpty()) {
            return ValidationResults.createInvalid("Issuer validation can not be performed because Jwt token does not contain 'jku' header parameter.");
        }
        return this.matchesTokenKeyUrlDomain(tokenKeyUrl);
    }

    private ValidationResult matchesTokenKeyUrlDomain(String tokenKeyUrl) {
        try {
            URI jkuUri = new URI(tokenKeyUrl);
            if (jkuUri.getHost() != null && jkuUri.getHost().endsWith(this.domain)) {
                return ValidationResults.createValid();
            }
        }
        catch (URISyntaxException e) {
            this.logger.error("Error: 'jku' header parameter '{}' does not provide a valid URI: {}.", new Object[]{tokenKeyUrl, e.getMessage(), e});
        }
        return ValidationResults.createInvalid("Issuer is not trusted because 'jku' '{}' does not match uaa domain '{}' of the identity service.", tokenKeyUrl, this.domain);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XsuaaJwtIssuerValidator that = (XsuaaJwtIssuerValidator)o;
        return this.domain.equals(that.domain);
    }

    public int hashCode() {
        return this.domain.hashCode();
    }
}

