/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.Assertions;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;

class TokenAuthenticatorResult
implements TokenAuthenticationResult {
    private Collection<String> scopes = Collections.emptyList();
    private Token token = null;
    private String reason = "";

    private TokenAuthenticatorResult() {
    }

    public static TokenAuthenticationResult createUnauthenticated(String reason) {
        Assertions.assertHasText((String)reason, (String)"Reason must contain text");
        TokenAuthenticatorResult result = new TokenAuthenticatorResult();
        result.reason = reason;
        return result;
    }

    public static TokenAuthenticationResult createAuthenticated(Collection<String> scopes, Token token) {
        TokenAuthenticatorResult result = new TokenAuthenticatorResult();
        result.scopes = scopes;
        result.token = token;
        return result;
    }

    public Token getToken() {
        return this.token;
    }

    public Principal getPrincipal() {
        return this.token.getPrincipal();
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public boolean isAuthenticated() {
        return this.reason.isEmpty();
    }

    public String getUnauthenticatedReason() {
        return this.reason;
    }
}

