/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.Assertions;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAudienceValidator
implements Validator<Token> {
    private static final Logger logger = LoggerFactory.getLogger(JwtAudienceValidator.class);
    private static final char DOT = '.';
    private final Set<String> clientIds = new LinkedHashSet<String>();

    JwtAudienceValidator(String clientId) {
        this.configureTrustedClientId(clientId);
    }

    JwtAudienceValidator configureTrustedClientId(String clientId) {
        Assertions.assertHasText((String)clientId, (String)"JwtAudienceValidator requires a clientId.");
        this.clientIds.add(clientId);
        logger.info("configured JwtAudienceValidator with clientId {}.", (Object)clientId);
        return this;
    }

    @Override
    public ValidationResult validate(Token token) {
        Set<String> allowedAudiences = JwtAudienceValidator.getAllowedAudiences(token);
        if (this.validateSameClientId(token) || this.validateDefault(allowedAudiences) || this.validateAudienceOfXsuaaBrokerClone(allowedAudiences)) {
            return ValidationResults.createValid();
        }
        return ValidationResults.createInvalid("Jwt token with audience {} is not issued for these clientIds: {}.", allowedAudiences, this.clientIds);
    }

    private boolean validateSameClientId(Token token) {
        String clientId;
        return Service.XSUAA.equals((Object)token.getService()) && token.hasClaim("cid") && this.clientIds.contains(clientId = token.getClaimAsString("cid"));
    }

    private boolean validateDefault(Set<String> allowedAudiences) {
        for (String configuredClientId : this.clientIds) {
            if (!allowedAudiences.contains(configuredClientId)) continue;
            return true;
        }
        return false;
    }

    private boolean validateAudienceOfXsuaaBrokerClone(Set<String> allowedAudiences) {
        for (String configuredClientId : this.clientIds) {
            if (!configuredClientId.contains("!b")) continue;
            for (String audience : allowedAudiences) {
                if (!audience.contains("|") || !audience.endsWith("|" + configuredClientId)) continue;
                return true;
            }
        }
        return false;
    }

    static Set<String> getAllowedAudiences(Token token) {
        LinkedHashSet<String> audiences = new LinkedHashSet<String>();
        for (String audience : token.getAudiences()) {
            if (audience.contains(".")) {
                String aud = JwtAudienceValidator.extractAppId(audience);
                if (aud.isEmpty()) continue;
                audiences.add(aud);
                continue;
            }
            audiences.add(audience);
        }
        if (audiences.isEmpty() && Service.XSUAA.equals((Object)token.getService())) {
            for (String scope : token.getClaimAsStringList("scope")) {
                if (!scope.contains(".")) continue;
                audiences.add(JwtAudienceValidator.extractAppId(scope));
            }
        }
        return audiences;
    }

    static String extractAppId(String scopeOrAudience) {
        return scopeOrAudience.substring(0, scopeOrAudience.indexOf(46)).trim();
    }
}

