/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.sap.cloud.security.config.CacheConfiguration;
import com.sap.cloud.security.token.validation.validators.JsonWebKey;
import com.sap.cloud.security.token.validation.validators.JsonWebKeyImpl;
import com.sap.cloud.security.token.validation.validators.JsonWebKeySet;
import com.sap.cloud.security.token.validation.validators.JsonWebKeySetFactory;
import com.sap.cloud.security.token.validation.validators.JwtSignatureAlgorithm;
import com.sap.cloud.security.token.validation.validators.TokenKeyCacheConfiguration;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.tokenflows.Cacheable;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth2TokenKeyServiceWithCache
implements Cacheable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2TokenKeyServiceWithCache.class);
    private OAuth2TokenKeyService tokenKeyService;
    private Cache<String, PublicKey> cache;
    private CacheConfiguration cacheConfiguration = TokenKeyCacheConfiguration.defaultConfiguration();

    private OAuth2TokenKeyServiceWithCache() {
    }

    public static OAuth2TokenKeyServiceWithCache getInstance() {
        OAuth2TokenKeyServiceWithCache instance = new OAuth2TokenKeyServiceWithCache();
        return instance;
    }

    @Deprecated
    public OAuth2TokenKeyServiceWithCache withCacheTime(int timeInSeconds) {
        this.withCacheConfiguration(TokenKeyCacheConfiguration.getInstance(Duration.ofSeconds(timeInSeconds), this.cacheConfiguration.getCacheSize()));
        return this;
    }

    @Deprecated
    public OAuth2TokenKeyServiceWithCache withCacheSize(int size) {
        this.withCacheConfiguration(TokenKeyCacheConfiguration.getInstance(this.cacheConfiguration.getCacheDuration(), size));
        return this;
    }

    public OAuth2TokenKeyServiceWithCache withCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = this.getCheckedConfiguration(cacheConfiguration);
        LOGGER.debug("Configured token key cache with cacheDuration={} seconds and cacheSize={}", (Object)this.getCacheConfiguration().getCacheDuration().getSeconds(), (Object)this.getCacheConfiguration().getCacheSize());
        return this;
    }

    public OAuth2TokenKeyServiceWithCache withTokenKeyService(OAuth2TokenKeyService tokenKeyService) {
        this.tokenKeyService = tokenKeyService;
        return this;
    }

    @Nullable
    public PublicKey getPublicKey(JwtSignatureAlgorithm keyAlgorithm, String keyId, URI keyUri) throws OAuth2ServiceException, InvalidKeySpecException, NoSuchAlgorithmException {
        Assertions.assertNotNull((Object)((Object)keyAlgorithm), (String)"keyAlgorithm must not be null.");
        Assertions.assertHasText((String)keyId, (String)"keyId must not be null.");
        Assertions.assertNotNull((Object)keyUri, (String)"keyUrl must not be null.");
        String cacheKey = OAuth2TokenKeyServiceWithCache.getUniqueCacheKey(keyAlgorithm, keyId, keyUri);
        PublicKey publicKey = (PublicKey)this.getCache().getIfPresent((Object)cacheKey);
        if (publicKey == null) {
            this.retrieveTokenKeysAndFillCache(keyUri);
        }
        return (PublicKey)this.getCache().getIfPresent((Object)cacheKey);
    }

    private TokenKeyCacheConfiguration getCheckedConfiguration(CacheConfiguration cacheConfiguration) {
        Assertions.assertNotNull((Object)cacheConfiguration, (String)"CacheConfiguration must not be null!");
        int size = cacheConfiguration.getCacheSize();
        Duration duration = cacheConfiguration.getCacheDuration();
        if (size < 1000) {
            int currentSize = this.getCacheConfiguration().getCacheSize();
            LOGGER.error("Tried to set cache size to {} but the cache size must be 1000 or more. Cache size will remain at: {}", (Object)size, (Object)currentSize);
            size = currentSize;
        }
        if (duration.getSeconds() < 600L) {
            Duration currentDuration = this.getCacheConfiguration().getCacheDuration();
            LOGGER.error("Tried to set cache duration to {} seconds but the cache duration must be at least 600 seconds. Cache duration will remain at: {} seconds", (Object)duration.getSeconds(), (Object)currentDuration.getSeconds());
            duration = currentDuration;
        }
        return TokenKeyCacheConfiguration.getInstance(duration, size);
    }

    private void retrieveTokenKeysAndFillCache(URI jwksUri) throws OAuth2ServiceException, InvalidKeySpecException, NoSuchAlgorithmException {
        JsonWebKeySet keySet = JsonWebKeySetFactory.createFromJson(this.getTokenKeyService().retrieveTokenKeys(jwksUri));
        if (keySet == null) {
            return;
        }
        Set<JsonWebKey> jwks = keySet.getAll();
        for (JsonWebKey jwk : jwks) {
            this.getCache().put((Object)OAuth2TokenKeyServiceWithCache.getUniqueCacheKey(jwk.getKeyAlgorithm(), jwk.getId(), jwksUri), (Object)jwk.getPublicKey());
        }
    }

    private Cache<String, PublicKey> getCache() {
        if (this.cache == null) {
            this.cache = Caffeine.newBuilder().expireAfterWrite(this.cacheConfiguration.getCacheDuration()).maximumSize((long)this.cacheConfiguration.getCacheSize()).build();
        }
        return this.cache;
    }

    private OAuth2TokenKeyService getTokenKeyService() {
        if (this.tokenKeyService == null) {
            this.tokenKeyService = new DefaultOAuth2TokenKeyService();
        }
        return this.tokenKeyService;
    }

    @Nonnull
    public CacheConfiguration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    public static String getUniqueCacheKey(JwtSignatureAlgorithm keyAlgorithm, String keyId, URI jwksUri) {
        return jwksUri + String.valueOf(JsonWebKeyImpl.calculateUniqueId(keyAlgorithm, keyId));
    }
}

