/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.json.DefaultJsonObject;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.token.InvalidTokenException;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractToken
implements Token {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractToken.class);
    private final DecodedJwt decodedJwt;
    protected final DefaultJsonObject tokenHeader;
    protected final DefaultJsonObject tokenBody;

    public AbstractToken(@Nonnull DecodedJwt decodedJwt) {
        this.tokenHeader = new DefaultJsonObject(decodedJwt.getHeader());
        this.tokenBody = new DefaultJsonObject(decodedJwt.getPayload());
        this.decodedJwt = decodedJwt;
    }

    public AbstractToken(@Nonnull String jwtToken) {
        this(Base64JwtDecoder.getInstance().decode(AbstractToken.removeBearer(jwtToken)));
    }

    @Nullable
    public String getHeaderParameterAsString(@Nonnull String headerName) {
        return this.tokenHeader.getAsString(headerName);
    }

    public boolean hasClaim(@Nonnull String claimName) {
        return this.tokenBody.contains(claimName);
    }

    public boolean hasHeaderParameter(@Nonnull String parameterName) {
        return this.tokenHeader.contains(parameterName);
    }

    @Nullable
    public String getClaimAsString(@Nonnull String claimName) {
        return this.tokenBody.getAsString(claimName);
    }

    @Nullable
    public List<String> getClaimAsStringList(@Nonnull String claimName) {
        return this.tokenBody.getAsStringList(claimName);
    }

    @Nullable
    public JsonObject getClaimAsJsonObject(String claimName) {
        return this.tokenBody.getJsonObject(claimName);
    }

    @Nullable
    public Instant getExpiration() {
        return this.tokenBody.getAsInstant("exp");
    }

    public boolean isExpired() {
        return this.getExpiration() == null ? true : this.getExpiration().isBefore(LocalDateTime.now().toInstant(ZoneOffset.UTC));
    }

    @Nullable
    public Instant getNotBefore() {
        return this.tokenBody.contains("nbf") ? this.tokenBody.getAsInstant("nbf") : this.tokenBody.getAsInstant("iat");
    }

    public String getTokenValue() {
        return this.decodedJwt.getEncodedToken();
    }

    public Set<String> getAudiences() {
        LinkedHashSet<String> audiences = new LinkedHashSet<String>();
        audiences.addAll(this.getClaimAsStringList("aud"));
        return audiences;
    }

    public boolean isXsuaaToken() {
        JsonObject externalAttributes;
        return this.tokenBody.contains("ext_attr") && "XSUAA".equals((externalAttributes = this.tokenBody.getJsonObject("ext_attr")).getAsString("enhancer"));
    }

    protected Principal createPrincipalByName(final String name) {
        return new Principal(){

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Principal)) {
                    return false;
                }
                Principal that = (Principal)o;
                return this.getName().equals(that.getName());
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.getName());
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    private static String removeBearer(@Nonnull String jwtToken) {
        Assertions.assertHasText((String)jwtToken, (String)"jwtToken must not be null / empty");
        Pattern bearerPattern = Pattern.compile("[B|b]earer ");
        return bearerPattern.matcher(jwtToken).replaceFirst("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractToken)) {
            return false;
        }
        AbstractToken that = (AbstractToken)o;
        return this.getTokenValue().equals(that.getTokenValue());
    }

    public int hashCode() {
        return Objects.hash(this.getTokenValue());
    }

    public String getZoneId() {
        return this.getClaimAsString("zone_uuid");
    }

    public String getClientId() {
        String clientId = this.getClaimAsString("azp");
        if (clientId == null || clientId.trim().isEmpty()) {
            Set<String> audiences = this.getAudiences();
            if (audiences.size() == 1) {
                return (String)audiences.stream().findFirst().get();
            }
            if (this.hasClaim("cid") && !this.getClaimAsString("cid").trim().isEmpty()) {
                LOGGER.warn("Usage of 'cid' claim is deprecated and should be replaced by 'azp' or 'aud' claims");
                return this.getClaimAsString("cid");
            }
            LOGGER.error("Couldn't get client id. Invalid authorized party or audience claims.");
            throw new InvalidTokenException("Couldn't get client id. Invalid authorized party or audience claims.");
        }
        return clientId;
    }

    public String toString() {
        return this.decodedJwt.toString();
    }
}

