/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import javax.annotation.Nullable;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IasXsuaaExchangeBroker {
    private static final Logger logger = LoggerFactory.getLogger(IasXsuaaExchangeBroker.class);

    @Nullable
    public String doIasToXsuaaXchange(CloseableHttpClient httpClient, Token token, OAuth2ServiceConfiguration serviceConfiguration) throws TokenFlowException {
        XsuaaTokenFlows tokenFlows = new XsuaaTokenFlows((OAuth2TokenService)new DefaultOAuth2TokenService(httpClient), (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(serviceConfiguration.getUrl()), new ClientCredentials(serviceConfiguration.getClientId(), serviceConfiguration.getClientSecret()));
        OAuth2TokenResponse tokenResponse = tokenFlows.userTokenFlow().token(token).execute();
        logger.debug("Response token from Ias to Xsuaa token exchange {}", (Object)tokenResponse.getAccessToken());
        return tokenResponse.getAccessToken();
    }
}

