/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.token.SapIdToken;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaToken;
import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;

class TokenFactory {
    private TokenFactory() {
    }

    public static Token create(String encodedToken) {
        DecodedJwt decodedJwt = Base64JwtDecoder.getInstance().decode(encodedToken);
        if (TokenFactory.isXsuaaToken(decodedJwt)) {
            return new XsuaaToken(decodedJwt);
        }
        return new SapIdToken(decodedJwt);
    }

    private static boolean isXsuaaToken(DecodedJwt decodedJwt) {
        String jwtPayload = decodedJwt.getPayload().toLowerCase();
        return jwtPayload.contains("ext_attr") && jwtPayload.contains("enhancer") && jwtPayload.contains("xsuaa");
    }
}

