/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.token.SapIdToken;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaToken;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

class TokenFactory {
    private TokenFactory() {
    }

    public static Token create(String jwtToken) {
        return TokenFactory.create(jwtToken, null);
    }

    public static Token create(String jwtToken, ScopeConverter localScopeConverter) {
        DecodedJwt decodedJwt = Base64JwtDecoder.getInstance().decode(TokenFactory.removeBearer(jwtToken));
        if (TokenFactory.isXsuaaToken(decodedJwt)) {
            return new XsuaaToken(decodedJwt).withScopeConverter(localScopeConverter);
        }
        return new SapIdToken(decodedJwt);
    }

    private static boolean isXsuaaToken(DecodedJwt decodedJwt) {
        String jwtPayload = decodedJwt.getPayload().toLowerCase();
        return jwtPayload.contains("ext_attr") && jwtPayload.contains("enhancer") && jwtPayload.contains("xsuaa");
    }

    private static String removeBearer(@Nonnull String jwtToken) {
        Assertions.assertHasText((String)jwtToken, (String)"jwtToken must not be null / empty");
        Pattern bearerPattern = Pattern.compile("[B|b]earer ");
        return bearerPattern.matcher(jwtToken).replaceFirst("");
    }
}

