/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.servlet.AbstractTokenAuthenticator;
import com.sap.cloud.security.servlet.IasXsuaaExchangeBroker;
import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.servlet.TokenAuthenticatorResult;
import com.sap.cloud.security.servlet.TokenFactory;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaScopeConverter;
import com.sap.cloud.security.token.XsuaaToken;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsuaaTokenAuthenticator
extends AbstractTokenAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XsuaaTokenAuthenticator.class);
    private static final String IAS_XSUAA_ENABLED = "IAS_XSUAA_XCHANGE_ENABLED";
    private IasXsuaaExchangeBroker exchangeBroker;

    public XsuaaTokenAuthenticator() {
        if (this.isIasXsuaaXchangeEnabled()) {
            this.exchangeBroker = new IasXsuaaExchangeBroker();
        }
    }

    XsuaaTokenAuthenticator(IasXsuaaExchangeBroker exchangeBroker) {
        this.exchangeBroker = exchangeBroker;
    }

    @Override
    public Token extractFromHeader(String authorizationHeader) {
        return new XsuaaToken(authorizationHeader).withScopeConverter(this.getScopeConverter());
    }

    @Override
    protected OAuth2ServiceConfiguration getServiceConfiguration() {
        OAuth2ServiceConfiguration config;
        OAuth2ServiceConfiguration oAuth2ServiceConfiguration = config = this.serviceConfiguration != null ? this.serviceConfiguration : Environments.getCurrent().getXsuaaConfiguration();
        if (config == null) {
            throw new IllegalStateException("There must be a service configuration.");
        }
        return config;
    }

    @Override
    @Nullable
    protected OAuth2ServiceConfiguration getOtherServiceConfiguration() {
        return Environments.getCurrent().getXsuaaConfigurationForTokenExchange();
    }

    @Override
    protected TokenAuthenticationResult authenticated(Token token) {
        Set<String> translatedScopes = this.getScopeConverter().convert(((XsuaaToken)token).getScopes());
        return TokenAuthenticatorResult.createAuthenticated(translatedScopes, token);
    }

    @Override
    public TokenAuthenticationResult validateRequest(ServletRequest request, ServletResponse response) {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String authorizationHeader = httpRequest.getHeader("Authorization");
            if (this.headerIsAvailable(authorizationHeader)) {
                try {
                    Token token = TokenFactory.create(authorizationHeader, this.getScopeConverter());
                    if (this.isIasXsuaaXchangeEnabled() && token.getService() == Service.IAS) {
                        token = new XsuaaToken(Objects.requireNonNull(this.exchangeBroker.doIasToXsuaaXchange(this.httpClient, token, this.serviceConfiguration), "IasXsuaaExchangeBroker is not provided"));
                    }
                    return this.tokenValidationResult(token);
                }
                catch (Exception e) {
                    return this.unauthenticated("Unexpected error occurred: " + e.getMessage());
                }
            }
            return this.unauthenticated("Authorization header is missing.");
        }
        return TokenAuthenticatorResult.createUnauthenticated("Could not process request " + request);
    }

    private ScopeConverter getScopeConverter() {
        return new XsuaaScopeConverter(this.getServiceConfiguration().getProperty("xsappname"));
    }

    private boolean isIasXsuaaXchangeEnabled() {
        String isEnabled = System.getenv(IAS_XSUAA_ENABLED);
        LOGGER.debug("System environment variable {} is set to {}", (Object)IAS_XSUAA_ENABLED, (Object)isEnabled);
        return isEnabled != null && !isEnabled.equalsIgnoreCase("false");
    }
}

