/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.SapIdToken;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.TokenFactory;
import com.sap.cloud.security.token.XsuaaScopeConverter;
import com.sap.cloud.security.token.XsuaaToken;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridTokenFactory
implements TokenFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HybridTokenFactory.class);
    private static String xsAppId;
    private static ScopeConverter xsScopeConverter;

    public Token create(String jwtToken) {
        Objects.requireNonNull(jwtToken, "Requires encoded jwtToken to create a Token instance.");
        DecodedJwt decodedJwt = Base64JwtDecoder.getInstance().decode(HybridTokenFactory.removeBearer(jwtToken));
        if (HybridTokenFactory.isXsuaaToken(decodedJwt)) {
            return new XsuaaToken(decodedJwt).withScopeConverter(HybridTokenFactory.getOrCreateScopeConverter());
        }
        return new SapIdToken(decodedJwt);
    }

    static void withXsuaaAppId(@Nonnull String xsAppId) {
        LOGGER.debug("XSUAA app id = {}", (Object)xsAppId);
        HybridTokenFactory.xsAppId = xsAppId;
        HybridTokenFactory.getOrCreateScopeConverter();
    }

    private static ScopeConverter getOrCreateScopeConverter() {
        if (xsScopeConverter == null) {
            xsScopeConverter = new XsuaaScopeConverter(HybridTokenFactory.getXsAppId());
        }
        return xsScopeConverter;
    }

    private static String getXsAppId() {
        if (xsAppId == null) {
            OAuth2ServiceConfiguration serviceConfiguration = Environments.getCurrent().getXsuaaConfiguration();
            if (serviceConfiguration == null) {
                throw new IllegalStateException("There must be a service configuration.");
            }
            xsAppId = serviceConfiguration.getProperty("xsappname");
        }
        return xsAppId;
    }

    private static boolean isXsuaaToken(DecodedJwt decodedJwt) {
        String jwtPayload = decodedJwt.getPayload().toLowerCase();
        return jwtPayload.contains("ext_attr") && jwtPayload.contains("enhancer") && jwtPayload.contains("xsuaa");
    }

    private static String removeBearer(@Nonnull String jwtToken) {
        Assertions.assertHasText((String)jwtToken, (String)"jwtToken must not be null / empty");
        Pattern bearerPattern = Pattern.compile("[B|b]earer ");
        return bearerPattern.matcher(jwtToken).replaceFirst("");
    }
}

