/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.CacheConfiguration;
import com.sap.cloud.security.xsuaa.Assertions;
import java.time.Duration;
import javax.annotation.Nonnull;

class TokenKeyCacheConfiguration
implements CacheConfiguration {
    private static final TokenKeyCacheConfiguration DEFAULT = TokenKeyCacheConfiguration.getInstance(Duration.ofMinutes(10L), 1000, false);
    private final Duration cacheDuration;
    private final int cacheSize;
    private final boolean cacheStatisticsEnabled;

    static TokenKeyCacheConfiguration getInstance(Duration cacheDuration, int cacheSize, boolean cacheStatisticsEnabled) {
        Assertions.assertNotNull((Object)cacheDuration, (String)"The cache duration write must not be null!");
        return new TokenKeyCacheConfiguration(cacheDuration, cacheSize, cacheStatisticsEnabled);
    }

    static TokenKeyCacheConfiguration defaultConfiguration() {
        return DEFAULT;
    }

    private TokenKeyCacheConfiguration(Duration cacheDuration, int cacheSize, boolean cacheStatisticsEnabled) {
        this.cacheDuration = cacheDuration;
        this.cacheSize = cacheSize;
        this.cacheStatisticsEnabled = cacheStatisticsEnabled;
    }

    @Nonnull
    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public boolean isCacheStatisticsEnabled() {
        return this.cacheStatisticsEnabled;
    }
}

