/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.xsuaa.Assertions;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class OAuth2ServiceConfigurationBuilder {
    private Service service;
    private boolean runInLegacyMode;
    private final Map<String, String> properties = new HashMap<String, String>();

    private OAuth2ServiceConfigurationBuilder() {
    }

    public static OAuth2ServiceConfigurationBuilder forService(@Nonnull Service service) {
        Assertions.assertNotNull((Object)service, (String)"Service must not be null!");
        OAuth2ServiceConfigurationBuilder instance = new OAuth2ServiceConfigurationBuilder();
        instance.service = service;
        return instance;
    }

    public static OAuth2ServiceConfigurationBuilder fromConfiguration(OAuth2ServiceConfiguration baseConfiguration) {
        OAuth2ServiceConfigurationBuilder builder = OAuth2ServiceConfigurationBuilder.forService(baseConfiguration.getService());
        builder.withProperties(baseConfiguration.getProperties());
        return builder;
    }

    public OAuth2ServiceConfigurationBuilder withClientId(String clientId) {
        this.properties.put("clientid", clientId);
        return this;
    }

    public OAuth2ServiceConfigurationBuilder withClientSecret(String clientSecret) {
        this.properties.put("clientsecret", clientSecret);
        return this;
    }

    public OAuth2ServiceConfigurationBuilder withUrl(String url) {
        this.properties.put("url", url);
        return this;
    }

    public OAuth2ServiceConfigurationBuilder withProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public OAuth2ServiceConfigurationBuilder withProperties(Map<String, String> properties) {
        properties.forEach((key, value) -> this.withProperty((String)key, (String)value));
        return this;
    }

    public OAuth2ServiceConfigurationBuilder runInLegacyMode(boolean isLegacyMode) {
        if (isLegacyMode && !this.service.equals((Object)Service.XSUAA)) {
            throw new UnsupportedOperationException("Legacy Mode is not supported for Service " + this.service);
        }
        this.runInLegacyMode = isLegacyMode;
        return this;
    }

    public OAuth2ServiceConfiguration build() {
        return new OAuth2ServiceConfigurationImpl(this.properties, this.service, this.runInLegacyMode);
    }

    private class OAuth2ServiceConfigurationImpl
    implements OAuth2ServiceConfiguration {
        private final Map<String, String> properties;
        private final boolean runInLegacyMode;
        private final Service service;

        private OAuth2ServiceConfigurationImpl(@Nonnull Map<String, String> properties, Service service, boolean runInLegacyMode) {
            this.properties = properties;
            this.service = service;
            this.runInLegacyMode = runInLegacyMode;
        }

        public String getClientId() {
            return this.properties.get("clientid");
        }

        public String getClientSecret() {
            return this.properties.get("clientsecret");
        }

        public URI getUrl() {
            return this.hasProperty("url") ? URI.create(this.properties.get("url")) : null;
        }

        public String getProperty(String name) {
            return this.properties.get(name);
        }

        public Map<String, String> getProperties() {
            return new HashMap<String, String>(this.properties);
        }

        public boolean hasProperty(String name) {
            return this.properties.containsKey(name);
        }

        public Service getService() {
            return this.service;
        }

        public boolean isLegacyMode() {
            return this.runInLegacyMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OAuth2ServiceConfigurationImpl that = (OAuth2ServiceConfigurationImpl)o;
            return this.runInLegacyMode == that.runInLegacyMode && this.properties.equals(that.properties) && this.service == that.service;
        }

        public int hashCode() {
            return Objects.hash(this.properties, this.runInLegacyMode, this.service);
        }

        public String toString() {
            return "OAuth2ServiceConfigurationImpl{properties=" + this.properties + ", service=" + this.service + ", legacyMode=" + this.isLegacyMode() + '}';
        }
    }
}

