/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.config.CacheConfiguration;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.servlet.HybridTokenFactory;
import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.servlet.TokenAuthenticator;
import com.sap.cloud.security.servlet.TokenAuthenticatorResult;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationListener;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.token.validation.validators.JwtValidatorBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTokenAuthenticator
implements TokenAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTokenAuthenticator.class);
    private final List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();
    private Validator<Token> tokenValidator;
    protected CloseableHttpClient httpClient;
    protected OAuth2ServiceConfiguration serviceConfiguration;
    private CacheConfiguration tokenKeyCacheConfiguration;

    public TokenAuthenticationResult validateRequest(ServletRequest request, ServletResponse response) {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String authorizationHeader = httpRequest.getHeader("Authorization");
            if (this.headerIsAvailable(authorizationHeader)) {
                try {
                    Token token = Token.create((String)authorizationHeader);
                    return this.tokenValidationResult(token);
                }
                catch (Exception e) {
                    return this.unauthenticated("Unexpected error occurred: " + e.getMessage());
                }
            }
            return this.unauthenticated("Authorization header is missing.");
        }
        return TokenAuthenticatorResult.createUnauthenticated("Could not process request " + request);
    }

    public AbstractTokenAuthenticator withCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.tokenKeyCacheConfiguration = cacheConfiguration;
        return this;
    }

    public AbstractTokenAuthenticator withHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public AbstractTokenAuthenticator withServiceConfiguration(OAuth2ServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
        this.setupTokenFactory();
        return this;
    }

    private void setupTokenFactory() {
        if (this.serviceConfiguration.getService() == Service.XSUAA) {
            HybridTokenFactory.withXsuaaAppId(this.serviceConfiguration.getProperty("xsappname"));
        }
    }

    public AbstractTokenAuthenticator withValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
        return this;
    }

    protected abstract OAuth2ServiceConfiguration getServiceConfiguration();

    @Nullable
    protected abstract OAuth2ServiceConfiguration getOtherServiceConfiguration();

    protected abstract Token extractFromHeader(String var1);

    Validator<Token> getOrCreateTokenValidator() {
        if (this.tokenValidator == null) {
            JwtValidatorBuilder jwtValidatorBuilder = JwtValidatorBuilder.getInstance(this.getServiceConfiguration()).withHttpClient(this.httpClient);
            jwtValidatorBuilder.configureAnotherServiceInstance(this.getOtherServiceConfiguration());
            Optional.ofNullable(this.tokenKeyCacheConfiguration).ifPresent(jwtValidatorBuilder::withCacheConfiguration);
            this.validationListeners.forEach(jwtValidatorBuilder::withValidatorListener);
            this.tokenValidator = jwtValidatorBuilder.build();
        }
        return this.tokenValidator;
    }

    TokenAuthenticationResult unauthenticated(String message) {
        logger.warn("Request could not be authenticated: {}.", (Object)message);
        return TokenAuthenticatorResult.createUnauthenticated(message);
    }

    protected TokenAuthenticationResult authenticated(Token token) {
        return TokenAuthenticatorResult.createAuthenticated(Collections.emptyList(), token);
    }

    boolean headerIsAvailable(String authorizationHeader) {
        return authorizationHeader != null && !authorizationHeader.isEmpty();
    }

    TokenAuthenticationResult tokenValidationResult(Token token) {
        Validator<Token> validator = this.getOrCreateTokenValidator();
        ValidationResult result = validator.validate(token);
        if (result.isValid()) {
            SecurityContext.setToken((Token)token);
            return this.authenticated(token);
        }
        return this.unauthenticated("Error during token validation: " + result.getErrorDescription());
    }
}

