/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.token.validation.validators.JsonWebKey;
import com.sap.cloud.security.token.validation.validators.JwtSignatureAlgorithm;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class JsonWebKeySet {
    private final Set<JsonWebKey> jsonWebKeys = new HashSet<JsonWebKey>();
    private final Map<String, Boolean> zoneIdAccepted = new HashMap<String, Boolean>();

    JsonWebKeySet() {
    }

    @Nullable
    public JsonWebKey getKeyByAlgorithmAndId(JwtSignatureAlgorithm keyAlgorithm, String keyId) {
        return this.getTokenStreamWithTypeAndKeyId(keyAlgorithm, keyId).findFirst().orElse(null);
    }

    public Set<JsonWebKey> getAll() {
        return this.jsonWebKeys;
    }

    public boolean put(@Nonnull JsonWebKey jsonWebKey) {
        return this.jsonWebKeys.add(jsonWebKey);
    }

    public void putAll(JsonWebKeySet jsonWebKeySet) {
        this.jsonWebKeys.addAll(jsonWebKeySet.getAll());
    }

    private Stream<JsonWebKey> getTokenStreamWithTypeAndKeyId(JwtSignatureAlgorithm algorithm, String keyId) {
        String kid = keyId != null ? keyId : "default-kid";
        return this.jsonWebKeys.stream().filter(jwk -> algorithm.equals((Object)jwk.getKeyAlgorithm())).filter(jwk -> kid.equals(jwk.getId()));
    }

    public boolean containsZoneId(String zoneId) {
        return this.zoneIdAccepted.containsKey(zoneId);
    }

    public boolean isZoneIdAccepted(String zoneId) {
        return this.zoneIdAccepted.get(zoneId);
    }

    public JsonWebKeySet withZoneId(String zoneId, boolean isAccepted) {
        this.zoneIdAccepted.put(zoneId, isAccepted);
        return this;
    }

    public String toString() {
        return this.jsonWebKeys.stream().map(String::valueOf).collect(Collectors.joining("|"));
    }
}

