/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.DefaultOidcConfigurationService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class OidcConfigurationServiceWithCache {
    private OidcConfigurationService oidcConfigurationService;
    private Cache<String, OAuth2ServiceEndpointsProvider> cache;
    private long cacheValidityInSeconds = 600L;
    private static final long MAX_CACHE_VALIDITY_IN_SECONDS = 900L;
    private long cacheSize = 1000L;

    private OidcConfigurationServiceWithCache() {
    }

    public static OidcConfigurationServiceWithCache getInstance() {
        return new OidcConfigurationServiceWithCache();
    }

    public OidcConfigurationServiceWithCache withOidcConfigurationService(OidcConfigurationService oidcConfigurationService) {
        this.oidcConfigurationService = oidcConfigurationService;
        return this;
    }

    public OidcConfigurationServiceWithCache withCacheTime(int timeInSeconds) {
        if (timeInSeconds < 600 || (long)timeInSeconds > 900L) {
            throw new IllegalArgumentException("The cache validity must be between 600 and 900 seconds.");
        }
        this.cacheValidityInSeconds = timeInSeconds;
        return this;
    }

    public OidcConfigurationServiceWithCache withCacheSize(int size) {
        if (size <= 1000) {
            throw new IllegalArgumentException("The cache size must be 1000 or more");
        }
        this.cacheSize = size;
        return this;
    }

    @Nullable
    public OAuth2ServiceEndpointsProvider getOrRetrieveEndpoints(URI discoveryEndpointUri) throws OAuth2ServiceException {
        Assertions.assertNotNull((Object)discoveryEndpointUri, (String)"discoveryEndpointUri must not be null.");
        String cacheKey = discoveryEndpointUri.toString();
        OAuth2ServiceEndpointsProvider endpointsProvider = (OAuth2ServiceEndpointsProvider)this.getCache().getIfPresent((Object)cacheKey);
        if (endpointsProvider == null) {
            endpointsProvider = this.getOidcConfigurationService().retrieveEndpoints(discoveryEndpointUri);
            if (endpointsProvider == null) {
                return null;
            }
            this.getCache().put((Object)cacheKey, (Object)endpointsProvider);
        }
        return (OAuth2ServiceEndpointsProvider)this.getCache().getIfPresent((Object)cacheKey);
    }

    private Cache<String, OAuth2ServiceEndpointsProvider> getCache() {
        if (this.cache == null) {
            this.cache = Caffeine.newBuilder().expireAfterWrite(this.cacheValidityInSeconds, TimeUnit.SECONDS).maximumSize(this.cacheSize).build();
        }
        return this.cache;
    }

    private OidcConfigurationService getOidcConfigurationService() {
        if (this.oidcConfigurationService == null) {
            this.oidcConfigurationService = new DefaultOidcConfigurationService();
        }
        return this.oidcConfigurationService;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }
}

