/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.CacheConfiguration;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.CombiningValidator;
import com.sap.cloud.security.token.validation.ValidationListener;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.token.validation.validators.JwtAudienceValidator;
import com.sap.cloud.security.token.validation.validators.JwtIssuerValidator;
import com.sap.cloud.security.token.validation.validators.JwtSignatureValidator;
import com.sap.cloud.security.token.validation.validators.JwtTimestampValidator;
import com.sap.cloud.security.token.validation.validators.OAuth2TokenKeyServiceWithCache;
import com.sap.cloud.security.token.validation.validators.OidcConfigurationServiceWithCache;
import com.sap.cloud.security.token.validation.validators.XsuaaJkuValidator;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.client.DefaultOidcConfigurationService;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtValidatorBuilder {
    private static final Map<OAuth2ServiceConfiguration, JwtValidatorBuilder> instances = new ConcurrentHashMap<OAuth2ServiceConfiguration, JwtValidatorBuilder>();
    private final Set<Validator<Token>> validators = new HashSet<Validator<Token>>();
    private final Set<ValidationListener> validationListeners = Collections.synchronizedSet(new HashSet());
    private OAuth2ServiceConfiguration configuration;
    private final Set<OAuth2ServiceConfiguration> otherConfigurations = Collections.synchronizedSet(new HashSet());
    private OidcConfigurationService oidcConfigurationService = null;
    private OAuth2TokenKeyService tokenKeyService = null;
    private Validator<Token> customAudienceValidator;
    private CacheConfiguration tokenKeyCacheConfiguration;
    private boolean isTenantIdCheckDisabled;
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtValidatorBuilder.class);

    private JwtValidatorBuilder() {
    }

    public static JwtValidatorBuilder getInstance(OAuth2ServiceConfiguration configuration) {
        Assertions.assertNotNull((Object)configuration, (String)"configuration must not be null");
        if (instances.containsKey(configuration)) {
            return instances.get(configuration);
        }
        JwtValidatorBuilder instance = new JwtValidatorBuilder();
        instance.configuration = configuration;
        instances.put(configuration, instance);
        return instance;
    }

    public JwtValidatorBuilder with(Validator<Token> validator) {
        this.validators.add(validator);
        return this;
    }

    public JwtValidatorBuilder withCacheConfiguration(CacheConfiguration tokenKeyCacheConfiguration) {
        this.tokenKeyCacheConfiguration = tokenKeyCacheConfiguration;
        return this;
    }

    public JwtValidatorBuilder withAudienceValidator(Validator<Token> audienceValidator) {
        LOGGER.info("Configures a custom audience validator: {}", audienceValidator.getClass());
        this.customAudienceValidator = audienceValidator;
        return this;
    }

    @Deprecated
    public JwtValidatorBuilder withOAuth2TokenKeyService(OAuth2TokenKeyService tokenKeyService) {
        this.tokenKeyService = tokenKeyService;
        return this;
    }

    @Deprecated
    public JwtValidatorBuilder withOidcConfigurationService(OidcConfigurationService oidcConfigurationService) {
        this.oidcConfigurationService = oidcConfigurationService;
        return this;
    }

    public JwtValidatorBuilder withHttpClient(CloseableHttpClient httpClient) {
        if (httpClient != null) {
            this.oidcConfigurationService = new DefaultOidcConfigurationService(httpClient);
            this.tokenKeyService = new DefaultOAuth2TokenKeyService(httpClient);
        }
        return this;
    }

    public JwtValidatorBuilder configureAnotherServiceInstance(@Nullable OAuth2ServiceConfiguration otherConfiguration) {
        if (Objects.nonNull(otherConfiguration)) {
            this.otherConfigurations.add(otherConfiguration);
        }
        return this;
    }

    public JwtValidatorBuilder withValidatorListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
        return this;
    }

    public JwtValidatorBuilder disableTenantIdCheck() {
        this.isTenantIdCheckDisabled = true;
        return this;
    }

    public CombiningValidator<Token> build() {
        List allValidators = this.createDefaultValidators();
        allValidators.addAll(this.validators);
        CombiningValidator<Token> combiningValidator = new CombiningValidator<Token>(allValidators);
        this.validationListeners.forEach(combiningValidator::registerValidationListener);
        return combiningValidator;
    }

    private List<Validator<Token>> createDefaultValidators() {
        ArrayList<Validator<Token>> defaultValidators = new ArrayList<Validator<Token>>();
        defaultValidators.add(new JwtTimestampValidator());
        if (this.configuration.getService() == Service.XSUAA) {
            if (!this.configuration.isLegacyMode()) {
                defaultValidators.add(new XsuaaJkuValidator(this.configuration.getProperty("uaadomain")));
            }
        } else if (this.configuration.getService() == Service.IAS && this.configuration.getDomains() != null && !this.configuration.getDomains().isEmpty()) {
            defaultValidators.add(new JwtIssuerValidator(this.configuration.getDomains()));
        }
        OAuth2TokenKeyServiceWithCache tokenKeyServiceWithCache = this.getTokenKeyServiceWithCache();
        Optional.ofNullable(this.tokenKeyCacheConfiguration).ifPresent(tokenKeyServiceWithCache::withCacheConfiguration);
        JwtSignatureValidator signatureValidator = new JwtSignatureValidator(this.configuration, tokenKeyServiceWithCache, this.getOidcConfigurationServiceWithCache());
        if (this.configuration.getService() == Service.IAS && this.isTenantIdCheckDisabled) {
            signatureValidator.disableTenantIdCheck();
        }
        defaultValidators.add(signatureValidator);
        Optional.ofNullable(this.customAudienceValidator).ifPresent(defaultValidators::add);
        if (this.customAudienceValidator == null) {
            defaultValidators.add(this.createAudienceValidator());
        }
        return defaultValidators;
    }

    private JwtAudienceValidator createAudienceValidator() {
        JwtAudienceValidator jwtAudienceValidator = new JwtAudienceValidator(this.configuration.getClientId());
        if (this.configuration.hasProperty("xsappname")) {
            jwtAudienceValidator.configureTrustedClientId(this.configuration.getProperty("xsappname"));
        }
        this.otherConfigurations.forEach(otherConfiguration -> {
            jwtAudienceValidator.configureTrustedClientId(otherConfiguration.getClientId());
            if (otherConfiguration.hasProperty("xsappname")) {
                jwtAudienceValidator.configureTrustedClientId(otherConfiguration.getProperty("xsappname"));
            }
        });
        return jwtAudienceValidator;
    }

    private OAuth2TokenKeyServiceWithCache getTokenKeyServiceWithCache() {
        if (this.tokenKeyService != null) {
            return OAuth2TokenKeyServiceWithCache.getInstance().withTokenKeyService(this.tokenKeyService);
        }
        return OAuth2TokenKeyServiceWithCache.getInstance();
    }

    private OidcConfigurationServiceWithCache getOidcConfigurationServiceWithCache() {
        if (this.oidcConfigurationService != null) {
            return OidcConfigurationServiceWithCache.getInstance().withOidcConfigurationService(this.oidcConfigurationService);
        }
        return OidcConfigurationServiceWithCache.getInstance();
    }
}

