/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.token.validation.validators.JwtSignatureAlgorithm;
import com.sap.cloud.security.token.validation.validators.OAuth2TokenKeyServiceWithCache;
import com.sap.cloud.security.token.validation.validators.OidcConfigurationServiceWithCache;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;

abstract class JwtSignatureValidator
implements Validator<Token> {
    protected final OAuth2TokenKeyServiceWithCache tokenKeyService;
    protected final OidcConfigurationServiceWithCache oidcConfigurationService;
    protected final OAuth2ServiceConfiguration configuration;

    JwtSignatureValidator(OAuth2ServiceConfiguration configuration, OAuth2TokenKeyServiceWithCache tokenKeyService, OidcConfigurationServiceWithCache oidcConfigurationService) {
        Assertions.assertNotNull((Object)configuration, (String)"JwtSignatureValidator requires configuration.");
        Assertions.assertNotNull((Object)tokenKeyService, (String)"JwtSignatureValidator requires a tokenKeyService.");
        Assertions.assertNotNull((Object)oidcConfigurationService, (String)"JwtSignatureValidator requires a oidcConfigurationService.");
        this.configuration = configuration;
        this.tokenKeyService = tokenKeyService;
        this.oidcConfigurationService = oidcConfigurationService;
    }

    @Override
    public ValidationResult validate(Token token) {
        PublicKey publicKey;
        String algHeader;
        if (token.getTokenValue() == null) {
            return ValidationResults.createInvalid("JWT token validation failed because token content was null.");
        }
        JwtSignatureAlgorithm algorithm = JwtSignatureAlgorithm.RS256;
        if (token.hasHeaderParameter("alg") && (algorithm = JwtSignatureAlgorithm.fromValue(algHeader = token.getHeaderParameterAsString("alg"))) == null) {
            return ValidationResults.createInvalid("JWT token validation with signature algorithm '" + algHeader + "' is not supported.");
        }
        try {
            publicKey = this.getPublicKey(token, algorithm);
        }
        catch (OAuth2ServiceException e) {
            return ValidationResults.createInvalid("Token signature can not be validated because JWKS could not be fetched: {}", e.getMessage());
        }
        catch (IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            return ValidationResults.createInvalid("Token signature can not be validated because: {}", e.getMessage());
        }
        if (publicKey == null) {
            return ValidationResults.createInvalid("Token signature can not be validated because JWKS was empty.");
        }
        return this.validateSignature(token, publicKey, algorithm);
    }

    protected abstract PublicKey getPublicKey(Token var1, JwtSignatureAlgorithm var2) throws OAuth2ServiceException, InvalidKeySpecException, NoSuchAlgorithmException;

    protected ValidationResult validateSignature(Token token, PublicKey publicKey, JwtSignatureAlgorithm algorithm) {
        Signature publicSignature;
        try {
            publicSignature = Signature.getInstance(algorithm.javaSignature());
        }
        catch (NoSuchAlgorithmException e) {
            return ValidationResults.createInvalid("Token signature can not be validated because implementation of algorithm could not be found: {}", e.getMessage());
        }
        String[] tokenSections = token.getTokenValue().split("\\.");
        if (tokenSections.length != 3) {
            return ValidationResults.createInvalid("Jwt token does not consist of three sections: 'header'.'payload'.'signature'.");
        }
        String headerAndPayload = tokenSections[0] + "." + tokenSections[1];
        String signature = tokenSections[2];
        try {
            publicSignature.initVerify(publicKey);
            publicSignature.update(headerAndPayload.getBytes(StandardCharsets.UTF_8));
            byte[] decodedSignatureBytes = Base64.getUrlDecoder().decode(signature);
            if (publicSignature.verify(decodedSignatureBytes)) {
                return ValidationResults.createValid();
            }
            return ValidationResults.createInvalid("Signature of Jwt Token is not valid: the identity provided by the JSON Web Token Key can not be trusted (Signature: {}).", signature);
        }
        catch (Exception e) {
            return ValidationResults.createInvalid("Unexpected Error occurred during Json Web Signature Validation: {}.", e.getMessage());
        }
    }
}

