/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.token.validation.validators.JsonWebKey;
import com.sap.cloud.security.token.validation.validators.JsonWebKeyImpl;
import com.sap.cloud.security.token.validation.validators.JsonWebKeySet;
import com.sap.cloud.security.token.validation.validators.JwtSignatureAlgorithm;
import org.json.JSONArray;
import org.json.JSONObject;

class JsonWebKeySetFactory {
    private JsonWebKeySetFactory() {
    }

    static JsonWebKeySet createFromJson(String json) {
        JsonWebKeySet keySet = new JsonWebKeySet();
        if (json != null) {
            JSONArray keys = new JSONObject(json).getJSONArray("keys");
            for (Object key : keys) {
                if (!(key instanceof JSONObject)) continue;
                keySet.put(JsonWebKeySetFactory.createJsonWebKey((JSONObject)key));
            }
        }
        return keySet;
    }

    private static JsonWebKey createJsonWebKey(JSONObject key) {
        String keyAlgorithm = null;
        String pemEncodedPublicKey = null;
        String keyId = null;
        String modulus = null;
        String publicExponent = null;
        String keyType = key.getString("kty");
        if (key.has("alg")) {
            keyAlgorithm = key.getString("alg");
        }
        if (key.has("value")) {
            pemEncodedPublicKey = key.getString("value");
        }
        if (key.has("kid")) {
            keyId = key.getString("kid");
        }
        if (key.has("n")) {
            modulus = key.getString("n");
        }
        if (key.has("e")) {
            publicExponent = key.getString("e");
        }
        JwtSignatureAlgorithm algorithm = keyAlgorithm != null ? JwtSignatureAlgorithm.fromValue(keyAlgorithm) : JwtSignatureAlgorithm.fromType(keyType);
        return new JsonWebKeyImpl(algorithm, keyId, modulus, publicExponent, pemEncodedPublicKey);
    }
}

