/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.Assertions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JwtIssuerValidator
implements Validator<Token> {
    private final List<String> domains;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    JwtIssuerValidator(List<String> domains) {
        Assertions.assertNotEmpty(domains, (String)"JwtIssuerValidator requires a domain(s).");
        this.domains = domains;
    }

    @Override
    public ValidationResult validate(Token token) {
        ValidationResult validationResult;
        Object issuer = token.getIssuer();
        if (token.getService().equals((Object)Service.IAS) && !((String)issuer).startsWith("http")) {
            issuer = "https://" + (String)issuer;
        }
        if ((validationResult = this.validateUrl((String)issuer)).isErroneous()) {
            return validationResult;
        }
        return this.matchesTokenIssuerUrl((String)issuer);
    }

    private ValidationResult matchesTokenIssuerUrl(String issuer) {
        URI issuerUri = URI.create(issuer);
        if (issuerUri.getQuery() == null && issuerUri.getFragment() == null && issuerUri.getHost() != null) {
            for (String d : this.domains) {
                if (!issuerUri.getHost().endsWith(d)) continue;
                return ValidationResults.createValid();
            }
        }
        return ValidationResults.createInvalid("Issuer is not trusted because issuer '{}' doesn't match any of these domains '{}' of the identity provider.", issuer, this.domains);
    }

    private ValidationResult validateUrl(String issuer) {
        try {
            if (issuer == null || issuer.trim().isEmpty()) {
                return ValidationResults.createInvalid("Issuer validation can not be performed because Jwt token does not contain an issuer claim.");
            }
            if (!issuer.startsWith("http")) {
                return ValidationResults.createInvalid("Issuer is not trusted because issuer '{}' does not provide a valid URI (missing http scheme). Please contact your Identity Provider Administrator.", issuer);
            }
            URI issuerUri = new URI(issuer);
            if (issuerUri.getQuery() == null && issuerUri.getFragment() == null && issuerUri.getHost() != null) {
                return ValidationResults.createValid();
            }
        }
        catch (URISyntaxException e) {
            this.logger.error("Error: issuer claim '{}' does not provide a valid URI: {}. Please contact your Identity Provider Administrator.", new Object[]{issuer, e.getMessage(), e});
        }
        return ValidationResults.createInvalid("Issuer is not trusted because issuer does not provide a valid URI. Please contact your Identity Provider Administrator.", issuer);
    }
}

