/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class JwtTimestampValidator
implements Validator<Token> {
    private static final TemporalAmount DEFAULT_TOLERANCE = Duration.ofMinutes(1L);
    private final Supplier<Instant> timeProvider;
    private final TemporalAmount tolerance;

    JwtTimestampValidator() {
        this(Instant::now, DEFAULT_TOLERANCE);
    }

    JwtTimestampValidator(Supplier<Instant> timeProvider, @Nullable TemporalAmount tolerance) {
        this.timeProvider = timeProvider;
        this.tolerance = tolerance != null ? tolerance : DEFAULT_TOLERANCE;
    }

    @Override
    public ValidationResult validate(Token token) {
        Instant expiration = token.getExpiration();
        if (expiration == null) {
            return ValidationResults.createInvalid("Jwt does not contain expiration (exp) claim. Cannot be validated!");
        }
        ValidationResult validationResult = this.checkExpiration(expiration);
        Instant notBefore = token.getNotBefore();
        if (notBefore != null && validationResult.isValid()) {
            validationResult = this.checkNotBefore(notBefore);
        }
        return validationResult;
    }

    private ValidationResult checkExpiration(Instant expiration) {
        if (this.isNotExpired(expiration)) {
            return ValidationResults.createValid();
        }
        return ValidationResults.createInvalid("Jwt expired at {}, time now: {}", expiration, this.now());
    }

    private ValidationResult checkNotBefore(Instant notBeforeTimestamp) {
        if (this.canBeAccepted(notBeforeTimestamp)) {
            return ValidationResults.createValid();
        }
        return ValidationResults.createInvalid("Jwt cannot be accepted before {}, time now: {}", notBeforeTimestamp, this.now());
    }

    private boolean canBeAccepted(Instant notBeforeTimestamp) {
        return this.now().isAfter(notBeforeTimestamp.minus(this.tolerance));
    }

    private boolean isNotExpired(Instant expiration) {
        return expiration.plus(this.tolerance).isAfter(this.now());
    }

    private Instant now() {
        return this.timeProvider.get();
    }
}

