/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.x509;

import com.sap.cloud.security.x509.Certificate;
import com.sap.cloud.security.x509.InvalidCertificateException;
import com.sap.cloud.security.x509.X509Parser;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Certificate
implements Certificate {
    private static final Logger LOGGER = LoggerFactory.getLogger(X509Certificate.class);
    private final java.security.cert.X509Certificate x509;
    private String thumbprint;
    private final String pem;

    private X509Certificate(java.security.cert.X509Certificate x509Certificate, String pem) {
        this.x509 = x509Certificate;
        this.pem = pem;
    }

    @Nullable
    public static X509Certificate newCertificate(String pem) {
        if (pem != null && !pem.isEmpty()) {
            try {
                return new X509Certificate(X509Parser.parseCertificate((String)pem), pem);
            }
            catch (CertificateException e) {
                LOGGER.debug("Could not parse the certificate string", (Throwable)e);
            }
        }
        return null;
    }

    public String getThumbprint() throws InvalidCertificateException {
        if (this.thumbprint == null) {
            try {
                this.thumbprint = X509Parser.getCertificateThumbprint((java.security.cert.X509Certificate)this.x509);
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                throw new InvalidCertificateException("Could not parse thumbprint", (Exception)e);
            }
        }
        return this.thumbprint;
    }

    public String getSubjectDN() {
        return this.x509.getSubjectX500Principal().getName("RFC1779").trim();
    }

    public Map<String, String> getSubjectDNMap() {
        return Stream.of(this.getSubjectDN().split(",")).collect(Collectors.toMap(dn -> dn.split("=")[0].trim(), dn -> dn.split("=")[1], (dn1, dn2) -> dn1 + "," + dn2));
    }

    public String getPEM() {
        return this.pem;
    }
}

