/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.servlet.AbstractTokenAuthenticator;
import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.servlet.TokenAuthenticatorResult;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaScopeConverter;
import com.sap.cloud.security.token.XsuaaToken;
import com.sap.cloud.security.x509.Certificate;
import com.sap.cloud.security.x509.X509Certificate;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.http.impl.client.CloseableHttpClient;

public class XsuaaTokenAuthenticator
extends AbstractTokenAuthenticator {
    public XsuaaTokenAuthenticator() {
        this.serviceConfiguration = Environments.getCurrent().getXsuaaConfiguration();
        this.httpClient = HttpClientFactory.create(this.serviceConfiguration != null ? this.serviceConfiguration.getClientIdentity() : null);
    }

    @Override
    public AbstractTokenAuthenticator withServiceConfiguration(OAuth2ServiceConfiguration serviceConfiguration) {
        super.withServiceConfiguration(serviceConfiguration);
        return this;
    }

    @Override
    public AbstractTokenAuthenticator withHttpClient(CloseableHttpClient httpClient) {
        super.withHttpClient(httpClient);
        return this;
    }

    @Override
    public Token extractFromHeader(String authorizationHeader) {
        return new XsuaaToken(authorizationHeader).withScopeConverter(this.getScopeConverter());
    }

    @Override
    protected OAuth2ServiceConfiguration getServiceConfiguration() {
        OAuth2ServiceConfiguration config;
        OAuth2ServiceConfiguration oAuth2ServiceConfiguration = config = this.serviceConfiguration != null ? this.serviceConfiguration : Environments.getCurrent().getXsuaaConfiguration();
        if (config == null) {
            throw new IllegalStateException("There must be a service configuration.");
        }
        return config;
    }

    @Override
    @Nullable
    protected OAuth2ServiceConfiguration getOtherServiceConfiguration() {
        return Environments.getCurrent().getXsuaaConfigurationForTokenExchange();
    }

    @Override
    protected TokenAuthenticationResult authenticated(Token token) {
        Set<String> translatedScopes = this.getScopeConverter().convert(((XsuaaToken)token).getScopes());
        return TokenAuthenticatorResult.createAuthenticated(translatedScopes, token);
    }

    @Override
    public TokenAuthenticationResult validateRequest(ServletRequest request, ServletResponse response) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                String authorizationHeader = httpRequest.getHeader("Authorization");
                if (this.headerIsAvailable(authorizationHeader)) {
                    try {
                        SecurityContext.setClientCertificate((Certificate)X509Certificate.newCertificate(this.getClientCertificate(httpRequest)));
                        Token token = Token.create((String)authorizationHeader);
                        return this.tokenValidationResult(token);
                    }
                    catch (Exception e) {
                        return TokenAuthenticatorResult.createUnauthenticated("Unexpected error occurred: " + e.getMessage());
                    }
                }
                return TokenAuthenticatorResult.createUnauthenticated("Authorization header is missing.");
            }
        }
        return TokenAuthenticatorResult.createUnauthenticated("Could not process request " + String.valueOf(request));
    }

    private ScopeConverter getScopeConverter() {
        return new XsuaaScopeConverter(this.getServiceConfiguration().getProperty("xsappname"));
    }
}

