/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.x509;

import com.sap.cloud.security.x509.Certificate;
import com.sap.cloud.security.x509.InvalidCertificateException;
import com.sap.cloud.security.x509.X509Parser;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Certificate
implements Certificate {
    private static final Logger LOGGER = LoggerFactory.getLogger(X509Certificate.class);
    private final java.security.cert.X509Certificate x509;
    private String thumbprint;
    private final String pem;

    private X509Certificate(java.security.cert.X509Certificate x509Certificate, String pem) {
        this.x509 = x509Certificate;
        this.pem = pem;
    }

    @Nullable
    public static X509Certificate newCertificate(String pemOrXfcc) {
        LOGGER.debug("Trying to parse certificate from XFCC header as PEM (or plain base64) encoded certificate.");
        X509Certificate result = X509Certificate.newCertificateFromPEM(pemOrXfcc);
        if (result == null) {
            LOGGER.debug("Trying to parse certificate from XFCC element with URL encoded \"Cert\" value.");
            result = X509Certificate.newCertificateFromXFCC(pemOrXfcc);
        }
        return result;
    }

    @Nullable
    public static X509Certificate newCertificateFromPEM(String pem) {
        if (pem != null && !pem.isEmpty()) {
            try {
                return new X509Certificate(X509Parser.parseCertificate((String)pem), pem);
            }
            catch (CertificateException e) {
                LOGGER.debug("Failed to parse cert from PEM/base64: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    @Nullable
    public static X509Certificate newCertificateFromXFCC(String headerValue) {
        Optional<Object> urlEncodedCert = Optional.empty();
        if (headerValue != null) {
            urlEncodedCert = Stream.of(headerValue.split(",")).flatMap(s -> Stream.of(s.split(";"))).filter(s -> s.split("=")[0].equalsIgnoreCase("Cert")).map(s -> {
                if (s.length() <= "Cert=".length()) {
                    return "";
                }
                if ((s = s.substring("Cert=".length())).startsWith("\"") && s.endsWith("\"")) {
                    s = s.substring(1, s.length() - 1).replace("\\\"", "\"");
                }
                return s;
            }).reduce((first, second) -> second);
        }
        if (urlEncodedCert.isPresent()) {
            String cert = URLDecoder.decode((String)urlEncodedCert.get(), StandardCharsets.UTF_8);
            return X509Certificate.newCertificateFromPEM(cert);
        }
        LOGGER.debug("XFCC header does not contain a certificate. Certificate is set to null.");
        return null;
    }

    public String getThumbprint() throws InvalidCertificateException {
        if (this.thumbprint == null) {
            try {
                this.thumbprint = X509Parser.getCertificateThumbprint((java.security.cert.X509Certificate)this.x509);
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                throw new InvalidCertificateException("Could not parse thumbprint", (Exception)e);
            }
        }
        return this.thumbprint;
    }

    public String getSubjectDN() {
        return this.x509.getSubjectX500Principal().getName("RFC1779").trim();
    }

    public Map<String, String> getSubjectDNMap() {
        return Stream.of(this.getSubjectDN().split(",")).collect(Collectors.toMap(dn -> dn.split("=")[0].trim(), dn -> dn.split("=")[1], (dn1, dn2) -> dn1 + "," + dn2));
    }

    public String getPEM() {
        return this.pem;
    }
}

