/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.servlet.AbstractTokenAuthenticator;
import com.sap.cloud.security.servlet.HybridTokenFactory;
import com.sap.cloud.security.servlet.IasTokenAuthenticator;
import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.servlet.XsuaaTokenAuthenticator;
import com.sap.cloud.security.token.DefaultIdTokenExtension;
import com.sap.cloud.security.token.IdTokenExtension;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.TokenExchangeMode;
import com.sap.cloud.security.token.XsuaaTokenExtension;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.DefaultXsuaaTokenExtension;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridTokenAuthenticator
extends AbstractTokenAuthenticator {
    private final IasTokenAuthenticator iasTokenAuthenticator = new IasTokenAuthenticator();
    private final XsuaaTokenAuthenticator xsuaaTokenAuthenticator = new XsuaaTokenAuthenticator();
    private final TokenExchangeMode tokenExchangeMode;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    OAuth2ServiceConfiguration iasConfig;
    OAuth2ServiceConfiguration xsuaaConfig;

    public HybridTokenAuthenticator(@Nonnull OAuth2ServiceConfiguration iasConfig, @Nonnull CloseableHttpClient httpClient, @Nonnull OAuth2ServiceConfiguration xsuaaConfig, @Nonnull TokenExchangeMode tokenExchangeMode) {
        this.tokenExchangeMode = tokenExchangeMode;
        this.httpClient = httpClient;
        this.iasConfig = iasConfig;
        this.xsuaaConfig = xsuaaConfig;
    }

    @Override
    public TokenAuthenticationResult validateRequest(ServletRequest request, ServletResponse response) {
        DecodedJwt decodedJwt;
        HttpServletRequest httpRequest;
        block16: {
            block15: {
                if (!(request instanceof HttpServletRequest)) break block15;
                httpRequest = (HttpServletRequest)request;
                if (response instanceof HttpServletResponse) break block16;
            }
            return this.unauthenticated("Could not process request " + String.valueOf(request));
        }
        String authz = httpRequest.getHeader("Authorization");
        if (!this.headerIsAvailable(authz)) {
            return this.unauthenticated("Authorization header is missing.");
        }
        try {
            decodedJwt = Base64JwtDecoder.getInstance().decode(HybridTokenFactory.removeBearer(authz));
        }
        catch (IllegalArgumentException e) {
            return this.unauthenticated("Unexpected error occurred: " + e.getMessage());
        }
        if (HybridTokenFactory.isXsuaaToken(decodedJwt)) {
            TokenAuthenticationResult authenticationResult = this.xsuaaTokenAuthenticator.validateRequest((ServletRequest)httpRequest, response);
            SecurityContext.setXsuaaToken((Token)authenticationResult.getToken());
            return authenticationResult;
        }
        TokenAuthenticationResult iasResult = this.iasTokenAuthenticator.validateRequest((ServletRequest)httpRequest, response);
        if (!iasResult.isAuthenticated()) {
            return iasResult;
        }
        try {
            switch (this.tokenExchangeMode) {
                case PROVIDE_XSUAA: {
                    this.logger.debug("Token exchange mode is 'PROVIDE_XSUAA'. Exchanging token...");
                    this.registerExtensions();
                    SecurityContext.getXsuaaToken();
                    break;
                }
                case FORCE_XSUAA: {
                    this.logger.debug("Token exchange mode is 'FORCE_XSUAA' and token is issued by IAS. Exchanging token...");
                    this.registerExtensions();
                    Token xsuaaToken = SecurityContext.getXsuaaToken();
                    SecurityContext.updateToken((Token)xsuaaToken);
                    return this.xsuaaTokenAuthenticator.authenticated(xsuaaToken);
                }
                case DISABLED: {
                    this.logger.debug("Token exchange is disabled. No exchange performed.");
                }
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return this.unauthenticated("Unexpected error during exchange from ID token to XSUAA token:" + e.getMessage());
        }
        return iasResult;
    }

    @Override
    protected OAuth2ServiceConfiguration getServiceConfiguration() {
        return this.xsuaaTokenAuthenticator.getServiceConfiguration();
    }

    @Override
    @Nullable
    protected OAuth2ServiceConfiguration getOtherServiceConfiguration() {
        return this.xsuaaTokenAuthenticator.getOtherServiceConfiguration();
    }

    @Override
    protected Token extractFromHeader(String authorizationHeader) {
        return this.xsuaaTokenAuthenticator.extractFromHeader(authorizationHeader);
    }

    private void registerExtensions() {
        DefaultOAuth2TokenService tokenService = new DefaultOAuth2TokenService(this.httpClient);
        SecurityContext.registerIdTokenExtension((IdTokenExtension)new DefaultIdTokenExtension((OAuth2TokenService)tokenService, this.iasConfig));
        SecurityContext.registerXsuaaTokenExtension((XsuaaTokenExtension)new DefaultXsuaaTokenExtension((OAuth2TokenService)tokenService, this.xsuaaConfig));
    }
}

