/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.servlet;

import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.json.JsonParsingException;
import com.sap.cloud.security.token.SapIdToken;
import com.sap.cloud.security.token.ScopeConverter;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.TokenFactory;
import com.sap.cloud.security.token.XsuaaScopeConverter;
import com.sap.cloud.security.token.XsuaaToken;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridTokenFactory
implements TokenFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HybridTokenFactory.class);
    static Optional<String> xsAppId;
    static ScopeConverter xsScopeConverter;

    public Token create(String jwtToken) {
        try {
            Objects.requireNonNull(jwtToken, "Requires encoded jwtToken to create a Token instance.");
            DecodedJwt decodedJwt = Base64JwtDecoder.getInstance().decode(HybridTokenFactory.removeBearer(jwtToken));
            if (HybridTokenFactory.isXsuaaToken(decodedJwt)) {
                return new XsuaaToken(decodedJwt).withScopeConverter(HybridTokenFactory.getOrCreateScopeConverter());
            }
            return new SapIdToken(decodedJwt);
        }
        catch (JsonParsingException e) {
            throw new JsonParsingException(String.format("Issue with Jwt parsing. Authorization header: %s - %s", jwtToken.substring(0, 20), e.getMessage()), (Throwable)e);
        }
    }

    static void withXsuaaAppId(@Nonnull String xsAppId) {
        LOGGER.debug("XSUAA app id = {}", (Object)xsAppId);
        HybridTokenFactory.xsAppId = Optional.of(xsAppId);
        HybridTokenFactory.getOrCreateScopeConverter();
    }

    private static ScopeConverter getOrCreateScopeConverter() {
        if (xsScopeConverter == null && HybridTokenFactory.getXsAppId().isPresent()) {
            xsScopeConverter = new XsuaaScopeConverter(HybridTokenFactory.getXsAppId().get());
        }
        return xsScopeConverter;
    }

    private static Optional<String> getXsAppId() {
        if (Objects.nonNull(xsAppId)) {
            return xsAppId;
        }
        OAuth2ServiceConfiguration serviceConfiguration = Environments.getCurrent().getXsuaaConfiguration();
        if (serviceConfiguration != null) {
            xsAppId = Optional.of(serviceConfiguration.getProperty("xsappname"));
        } else {
            LOGGER.warn("There is no xsuaa service configuration with 'xsappname' property: no local scope check possible.");
            xsAppId = Optional.empty();
        }
        return xsAppId;
    }

    protected static boolean isXsuaaToken(DecodedJwt decodedJwt) {
        String jwtPayload = decodedJwt.getPayload().toLowerCase();
        return jwtPayload.contains("ext_attr") && jwtPayload.contains("enhancer") && jwtPayload.contains("xsuaa") || jwtPayload.contains("\"zid\":\"uaa\",");
    }

    protected static String removeBearer(@Nonnull String jwtToken) {
        Assertions.assertHasText((String)jwtToken, (String)"jwtToken must not be null / empty");
        Pattern bearerPattern = Pattern.compile("[B|b]earer ");
        return bearerPattern.matcher(jwtToken).replaceFirst("");
    }
}

