/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.IdTokenExtension;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIdTokenExtension
implements IdTokenExtension {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIdTokenExtension.class);
    private final OAuth2TokenService tokenService;
    private final OAuth2ServiceConfiguration iasConfig;

    public DefaultIdTokenExtension(OAuth2TokenService tokenService, OAuth2ServiceConfiguration iasConfig) {
        this.tokenService = Objects.requireNonNull(tokenService);
        this.iasConfig = Objects.requireNonNull(iasConfig);
    }

    public Token resolveIdToken(@Nullable Token idToken) {
        if (Objects.nonNull(idToken) && !idToken.isExpired()) {
            return idToken;
        }
        Token token = SecurityContext.getInitialToken();
        if (token == null) {
            throw new IllegalArgumentException("Cannot resolve ID token with no access token present");
        }
        if (this.isTechnicalUser(token)) {
            throw new IllegalArgumentException("Cannot get ID token for technical user.");
        }
        if (!this.isAccessToken(token)) {
            LOG.debug("Incoming Token is already an ID Token. Returning incoming Token");
            return token;
        }
        try {
            return Token.create((String)this.exchangeAccessToIDToken(token).getAccessToken());
        }
        catch (OAuth2ServiceException e) {
            LOG.warn("Failed to retrieve ID-Token", (Throwable)e);
            return null;
        }
    }

    private boolean isAccessToken(Token token) {
        List audiences = token.getClaimAsStringList("aud");
        return audiences.size() == 1 && ((String)audiences.get(0)).equals(token.getClientId());
    }

    private boolean isTechnicalUser(Token token) {
        String subject = token.getClaimAsString("sub");
        String azp = token.getClientId();
        if (subject == null || azp == null || subject.isBlank() || azp.isBlank()) {
            return false;
        }
        return subject.equals(azp);
    }

    private OAuth2TokenResponse exchangeAccessToIDToken(Token accessToken) throws OAuth2ServiceException {
        String certPem = this.iasConfig.getProperty("certificate");
        String keyPem = this.iasConfig.getProperty("key");
        String clientId = this.iasConfig.getClientId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        params.put("assertion", accessToken.getTokenValue());
        params.put("token_format", "jwt");
        params.put("refresh_expiry", "0");
        params.put("client_id", clientId);
        if (certPem != null && keyPem != null && Objects.nonNull(this.iasConfig.getCertUrl())) {
            URI certUrlEndpoint = URI.create(this.iasConfig.getCertUrl().toString() + "/oauth2/token");
            return this.tokenService.retrieveAccessTokenViaJwtBearerTokenGrant(certUrlEndpoint, (ClientIdentity)new ClientCertificate(clientId, certPem, keyPem), accessToken.getTokenValue(), null, params, false);
        }
        URI tokenUrlEndpoint = URI.create(this.iasConfig.getUrl().toString() + "/oauth2/token");
        return this.tokenService.retrieveAccessTokenViaJwtBearerTokenGrant(tokenUrlEndpoint, (ClientIdentity)new ClientCredentials(clientId, this.iasConfig.getClientSecret()), accessToken.getTokenValue(), null, params, false);
    }
}

