/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TokenExchangeMode {
    DISABLED,
    PROVIDE_XSUAA,
    FORCE_XSUAA;


    public static TokenExchangeMode fromString(String value) {
        Logger logger = LoggerFactory.getLogger(TokenExchangeMode.class);
        if (value == null || value.isEmpty()) {
            return DISABLED;
        }
        return switch (value.toLowerCase()) {
            case "disabled" -> DISABLED;
            case "providexsuaa" -> PROVIDE_XSUAA;
            case "forcexsuaa" -> FORCE_XSUAA;
            default -> {
                logger.error("Wrong Token exchange mode received. Disabling Token Exchange...");
                yield DISABLED;
            }
        };
    }
}

